/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.externalfiles.DownloadExternalFile;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.importer.FulltextFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindFullTextAction
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindFullTextAction.class);
    private static final int WARNING_LIMIT = 5;
    private final BasePanel basePanel;
    private final Map<Optional<URL>, BibEntry> downloads = new ConcurrentHashMap<Optional<URL>, BibEntry>();

    public FindFullTextAction(BasePanel basePanel) {
        this.basePanel = basePanel;
    }

    @Override
    public void init() throws Exception {
        if (!this.basePanel.getSelectedEntries().isEmpty()) {
            this.basePanel.output(Localization.lang("Looking for full text document...", new String[0]));
        } else {
            LOGGER.debug("No entry selected for fulltext download.");
        }
    }

    @Override
    public void run() {
        if (this.basePanel.getSelectedEntries().size() >= 5) {
            Object[] options = new String[]{Localization.lang("Look up full text documents", new String[0]), Localization.lang("Cancel", new String[0])};
            int answer = JOptionPane.showOptionDialog(this.basePanel.frame(), Localization.lang("You are about to look up full text documents for %0 entries.", String.valueOf(this.basePanel.getSelectedEntries().size())) + "\n" + Localization.lang("JabRef will send at least one request per entry to a publisher.", new String[0]) + "\n" + Localization.lang("Do you still want to continue?", new String[0]), Localization.lang("Look up full text documents", new String[0]), 2, 2, null, options, options[0]);
            if (answer != 0) {
                this.basePanel.output(Localization.lang("Operation canceled.", new String[0]));
                return;
            }
        }
        for (BibEntry entry : this.basePanel.getSelectedEntries()) {
            FulltextFetchers fetchers = new FulltextFetchers(Globals.prefs.getImportFormatPreferences());
            this.downloads.put(fetchers.findFullTextPDF(entry), entry);
        }
    }

    @Override
    public void update() {
        ArrayList<Optional<URL>> finishedTasks = new ArrayList<Optional<URL>>();
        for (Map.Entry<Optional<URL>, BibEntry> entry : this.downloads.entrySet()) {
            BibEntry entry2 = entry.getValue();
            Optional<URL> result = entry.getKey();
            if (result.isPresent()) {
                Optional<Path> dir = this.basePanel.getBibDatabaseContext().getFirstExistingFileDir(Globals.prefs.getFileDirectoryPreferences());
                if (!dir.isPresent()) {
                    JOptionPane.showMessageDialog(this.basePanel.frame(), Localization.lang("Main file directory not set!", new String[0]) + " " + Localization.lang("Preferences", new String[0]) + " -> " + Localization.lang("File", new String[0]), Localization.lang("Directory not found", new String[0]), 0);
                    return;
                }
                DownloadExternalFile fileDownload = new DownloadExternalFile(this.basePanel.frame(), this.basePanel.getBibDatabaseContext(), entry2);
                try {
                    fileDownload.download(result.get(), "application/pdf", file -> DefaultTaskExecutor.runInJavaFXThread(() -> {
                        Optional<FieldChange> fieldChange = entry2.addFile(file);
                        if (fieldChange.isPresent()) {
                            UndoableFieldChange edit = new UndoableFieldChange(entry2, "file", entry2.getField("file").orElse(null), fieldChange.get().getNewValue());
                            this.basePanel.getUndoManager().addEdit(edit);
                            this.basePanel.markBaseChanged();
                        }
                    }));
                }
                catch (IOException e) {
                    LOGGER.warn("Problem downloading file", e);
                    this.basePanel.output(Localization.lang("Full text document download failed for entry %0", entry2.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
                }
                this.basePanel.output(Localization.lang("Finished downloading full text document for entry %0.", entry2.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
            } else {
                String title = Localization.lang("No full text document found", new String[0]);
                String message = Localization.lang("No full text document found for entry %0.", entry2.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0])));
                this.basePanel.output(message);
                JOptionPane.showMessageDialog(this.basePanel.frame(), message, title, 0);
            }
            finishedTasks.add(result);
        }
        for (Optional optional : finishedTasks) {
            this.downloads.remove(optional);
        }
    }
}

