/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import javax.swing.undo.UndoManager;
import org.jabref.Globals;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.ContentSelectorSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.fieldeditors.BibtexKeyEditor;
import org.jabref.gui.fieldeditors.DateEditor;
import org.jabref.gui.fieldeditors.EditorTypeEditorViewModel;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.GenderEditorViewModel;
import org.jabref.gui.fieldeditors.IdentifierEditor;
import org.jabref.gui.fieldeditors.JournalEditor;
import org.jabref.gui.fieldeditors.KeywordsEditor;
import org.jabref.gui.fieldeditors.LinkedEntriesEditor;
import org.jabref.gui.fieldeditors.LinkedFilesEditor;
import org.jabref.gui.fieldeditors.MonthEditorViewModel;
import org.jabref.gui.fieldeditors.MultilineEditor;
import org.jabref.gui.fieldeditors.OptionEditor;
import org.jabref.gui.fieldeditors.OwnerEditor;
import org.jabref.gui.fieldeditors.PaginationEditorViewModel;
import org.jabref.gui.fieldeditors.PatentTypeEditorViewModel;
import org.jabref.gui.fieldeditors.PersonsEditor;
import org.jabref.gui.fieldeditors.SimpleEditor;
import org.jabref.gui.fieldeditors.TypeEditorViewModel;
import org.jabref.gui.fieldeditors.UrlEditor;
import org.jabref.gui.fieldeditors.YesNoEditorViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.entry.Month;
import org.jabref.model.metadata.MetaData;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldEditors {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldEditors.class);

    public static FieldEditorFX getForField(String fieldName, TaskExecutor taskExecutor, DialogService dialogService, JournalAbbreviationLoader journalAbbreviationLoader, JournalAbbreviationPreferences journalAbbreviationPreferences, JabRefPreferences preferences, BibDatabaseContext databaseContext, String entryType, SuggestionProviders suggestionProviders, UndoManager undoManager) {
        Set<FieldProperty> fieldExtras = InternalBibtexFields.getFieldProperties(fieldName);
        AutoCompleteSuggestionProvider<?> suggestionProvider = FieldEditors.getSuggestionProvider(fieldName, suggestionProviders, databaseContext.getMetaData());
        FieldCheckers fieldCheckers = new FieldCheckers(databaseContext, preferences.getFileDirectoryPreferences(), journalAbbreviationLoader.getRepository(journalAbbreviationPreferences), preferences.getBoolean("enforceLegalBibtexKey"));
        if (preferences.getTimestampPreferences().getTimestampField().equals(fieldName) || fieldExtras.contains((Object)FieldProperty.DATE)) {
            if (fieldExtras.contains((Object)FieldProperty.ISO_DATE)) {
                return new DateEditor(fieldName, DateTimeFormatter.ofPattern("[uuuu][-MM][-dd]"), suggestionProvider, fieldCheckers);
            }
            return new DateEditor(fieldName, DateTimeFormatter.ofPattern(Globals.prefs.getTimestampPreferences().getTimestampFormat()), suggestionProvider, fieldCheckers);
        }
        if (fieldExtras.contains((Object)FieldProperty.EXTERNAL)) {
            return new UrlEditor(fieldName, dialogService, suggestionProvider, fieldCheckers, preferences);
        }
        if (fieldExtras.contains((Object)FieldProperty.JOURNAL_NAME)) {
            return new JournalEditor(fieldName, journalAbbreviationLoader, preferences, suggestionProvider, fieldCheckers);
        }
        if (fieldExtras.contains((Object)FieldProperty.DOI) || fieldExtras.contains((Object)FieldProperty.EPRINT) || fieldExtras.contains((Object)FieldProperty.ISBN)) {
            return new IdentifierEditor(fieldName, taskExecutor, dialogService, suggestionProvider, fieldCheckers, preferences);
        }
        if (fieldExtras.contains((Object)FieldProperty.OWNER)) {
            return new OwnerEditor(fieldName, preferences, suggestionProvider, fieldCheckers);
        }
        if (fieldExtras.contains((Object)FieldProperty.FILE_EDITOR)) {
            return new LinkedFilesEditor(fieldName, dialogService, databaseContext, taskExecutor, suggestionProvider, fieldCheckers, preferences);
        }
        if (fieldExtras.contains((Object)FieldProperty.YES_NO)) {
            return new OptionEditor<String>(new YesNoEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.MONTH)) {
            return new OptionEditor<Month>(new MonthEditorViewModel(fieldName, suggestionProvider, databaseContext.getMode(), fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.GENDER)) {
            return new OptionEditor<String>(new GenderEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.EDITOR_TYPE)) {
            return new OptionEditor<String>(new EditorTypeEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.PAGINATION)) {
            return new OptionEditor<String>(new PaginationEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.TYPE)) {
            if ("patent".equalsIgnoreCase(entryType)) {
                return new OptionEditor<String>(new PatentTypeEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
            }
            return new OptionEditor<String>(new TypeEditorViewModel(fieldName, suggestionProvider, fieldCheckers));
        }
        if (fieldExtras.contains((Object)FieldProperty.SINGLE_ENTRY_LINK) || fieldExtras.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) {
            return new LinkedEntriesEditor(fieldName, databaseContext, suggestionProvider, fieldCheckers);
        }
        if (fieldExtras.contains((Object)FieldProperty.PERSON_NAMES)) {
            return new PersonsEditor(fieldName, suggestionProvider, preferences, fieldCheckers);
        }
        if ("keywords".equals(fieldName)) {
            return new KeywordsEditor(fieldName, suggestionProvider, fieldCheckers, preferences);
        }
        if (fieldExtras.contains((Object)FieldProperty.MULTILINE_TEXT)) {
            return new MultilineEditor(fieldName, suggestionProvider, fieldCheckers, preferences);
        }
        if (fieldExtras.contains((Object)FieldProperty.KEY)) {
            return new BibtexKeyEditor(fieldName, preferences, suggestionProvider, fieldCheckers, preferences.getBibtexKeyPatternPreferences(), databaseContext, undoManager);
        }
        return new SimpleEditor(fieldName, suggestionProvider, fieldCheckers, preferences);
    }

    private static AutoCompleteSuggestionProvider<?> getSuggestionProvider(String fieldName, SuggestionProviders suggestionProviders, MetaData metaData) {
        AutoCompleteSuggestionProvider<String> suggestionProvider = suggestionProviders.getForField(fieldName);
        List<String> contentSelectorValues = metaData.getContentSelectorValuesForField(fieldName);
        if (!contentSelectorValues.isEmpty()) {
            try {
                return new ContentSelectorSuggestionProvider(suggestionProvider, contentSelectorValues);
            }
            catch (ClassCastException exception) {
                LOGGER.error("Content selectors are only supported for normal fields with string-based auto completion.");
                return suggestionProvider;
            }
        }
        return suggestionProvider;
    }
}

