/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.HBox;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.OptionEditorViewModel;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.model.entry.BibEntry;

public class OptionEditor<T>
extends HBox
implements FieldEditorFX {
    @FXML
    private OptionEditorViewModel<T> viewModel;
    @FXML
    private ComboBox<T> comboBox;

    public OptionEditor(OptionEditorViewModel<T> viewModel) {
        this.viewModel = viewModel;
        ControlHelper.loadFXMLForControl((Parent)this);
        this.comboBox.setConverter(viewModel.getStringConverter());
        this.comboBox.setCellFactory(new ViewModelListCellFactory().withText(viewModel::convertToDisplayText));
        this.comboBox.getItems().setAll(viewModel.getItems());
        this.comboBox.getEditor().textProperty().bindBidirectional((Property)viewModel.textProperty());
    }

    public OptionEditorViewModel<T> getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

