/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.filelist;

import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.model.entry.LinkedFile;

public class FileListEntry {
    private String description;
    private String link;
    private Optional<ExternalFileType> type;

    public FileListEntry(String description, String link) {
        this(description, link, Optional.empty());
    }

    public FileListEntry(String description, String link, ExternalFileType type) {
        this.setDescription(Objects.requireNonNull(description));
        this.setLink(Objects.requireNonNull(link));
        this.setType(Optional.of(Objects.requireNonNull(type)));
    }

    public FileListEntry(String description, String link, Optional<ExternalFileType> type) {
        this.setDescription(Objects.requireNonNull(description));
        this.setLink(Objects.requireNonNull(link));
        this.setType(Objects.requireNonNull(type));
    }

    public String[] getStringArrayRepresentation() {
        return new String[]{this.getDescription(), this.getLink(), this.getTypeName()};
    }

    private String getTypeName() {
        return this.getType().isPresent() ? this.getType().get().getName() : "";
    }

    public String toString() {
        return this.getDescription() + " : " + this.getLink() + " : " + this.getType().orElse(null);
    }

    public LinkedFile toParsedFileField() {
        return new LinkedFile(this.getDescription(), this.getLink(), this.getType().isPresent() ? this.getType().get().getName() : "");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Optional<ExternalFileType> getType() {
        return this.type;
    }

    public void setType(Optional<ExternalFileType> type) {
        this.type = type;
    }
}

