/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.io.File;
import java.util.Optional;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.importer.EntryFromFileCreator;
import org.jabref.model.entry.BibEntry;

public class EntryFromExternalFileCreator
extends EntryFromFileCreator {
    public EntryFromExternalFileCreator(ExternalFileType externalFileType) {
        super(externalFileType);
    }

    @Override
    public boolean accept(File f) {
        return f.getName().endsWith("." + this.externalFileType.getExtension());
    }

    @Override
    protected Optional<BibEntry> createBibtexEntry(File file) {
        if (!this.accept(file)) {
            return Optional.empty();
        }
        return Optional.of(new BibEntry());
    }

    @Override
    public String getFormatName() {
        return this.externalFileType.getName();
    }
}

