/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.dialogs.BackupUIManager;
import org.jabref.gui.importer.ParserResultWarningDialog;
import org.jabref.gui.importer.actions.CheckForNewEntryTypesAction;
import org.jabref.gui.importer.actions.GUIPostOpenAction;
import org.jabref.gui.importer.actions.HandleDuplicateWarnings;
import org.jabref.gui.importer.actions.MergeReviewIntoCommentAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.shared.SharedDatabaseUIManager;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.autosaveandbackup.BackupManager;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.exception.NotASharedDatabaseException;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileBasedLock;
import org.jabref.migrations.FileLinksUpgradeWarning;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.shared.DatabaseNotSupportedException;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDatabaseAction
extends MnemonicAwareAction {
    public static final Logger LOGGER = LoggerFactory.getLogger(OpenDatabaseAction.class);
    private static final List<GUIPostOpenAction> POST_OPEN_ACTIONS = Arrays.asList(new MergeReviewIntoCommentAction(), new FileLinksUpgradeWarning(), new CheckForNewEntryTypesAction(), new HandleDuplicateWarnings());
    private final boolean showDialog;
    private final JabRefFrame frame;

    public OpenDatabaseAction(JabRefFrame frame, boolean showDialog) {
        super(IconTheme.JabRefIcon.OPEN.getIcon());
        this.frame = frame;
        this.showDialog = showDialog;
        this.putValue("Name", Localization.menuTitle("Open library", new String[0]));
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.OPEN_DATABASE));
        this.putValue("ShortDescription", Localization.lang("Open BibTeX library", new String[0]));
    }

    public static void performPostOpenActions(BasePanel panel, ParserResult result) {
        for (GUIPostOpenAction action : POST_OPEN_ACTIONS) {
            if (!action.isActionNecessary(result)) continue;
            action.performAction(panel, result);
            panel.frame().getTabbedPane().setSelectedComponent(panel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Path> filesToOpen = new ArrayList<Path>();
        if (this.showDialog) {
            FXDialogService ds = new FXDialogService();
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BIBTEX_DB).withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(Paths.get(Globals.prefs.get("workingDirectory"), new String[0])).build();
            List chosenFiles = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialogAndGetMultipleFiles(fileDialogConfiguration));
            filesToOpen.addAll(chosenFiles);
        } else {
            LOGGER.info("Name " + e.getActionCommand());
            filesToOpen.add(Paths.get(StringUtil.getCorrectFileName(e.getActionCommand(), "bib"), new String[0]));
        }
        this.openFiles(filesToOpen, true);
    }

    public void openFile(Path file, boolean raisePanel) {
        ArrayList<Path> filesToOpen = new ArrayList<Path>();
        filesToOpen.add(file);
        this.openFiles(filesToOpen, raisePanel);
    }

    public void openFilesAsStringList(List<String> fileNamesToOpen, boolean raisePanel) {
        List<Path> filesToOpen = fileNamesToOpen.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        this.openFiles(filesToOpen, raisePanel);
    }

    public void openFiles(List<Path> filesToOpen, boolean raisePanel) {
        BasePanel toRaise = null;
        int initialCount = filesToOpen.size();
        int removed = 0;
        Iterator<Path> iterator = filesToOpen.iterator();
        block0: while (iterator.hasNext()) {
            Path file = iterator.next();
            for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel basePanel = this.frame.getBasePanelAt(i);
                if (!basePanel.getBibDatabaseContext().getDatabasePath().isPresent() || !basePanel.getBibDatabaseContext().getDatabasePath().get().equals(file)) continue;
                iterator.remove();
                if (++removed != initialCount) continue block0;
                toRaise = basePanel;
                continue block0;
            }
        }
        if (!filesToOpen.isEmpty()) {
            List<Path> theFiles = Collections.unmodifiableList(filesToOpen);
            JabRefExecutorService.INSTANCE.execute(() -> {
                for (Path theFile : theFiles) {
                    this.openTheFile(theFile, raisePanel);
                }
            });
            for (Path theFile : theFiles) {
                this.frame.getFileHistory().newFile(theFile.toString());
            }
        } else if (toRaise != null) {
            this.frame.output(Localization.lang("File '%0' is already open.", toRaise.getBibDatabaseContext().getDatabaseFile().get().getPath()));
            this.frame.getTabbedPane().setSelectedComponent(toRaise);
        }
        this.frame.output(Localization.lang("Files opened", new String[0]) + ": " + filesToOpen.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openTheFile(Path file, boolean raisePanel) {
        ParserResult result;
        Objects.requireNonNull(file);
        if (!Files.exists(file, new LinkOption[0])) return;
        Path fileToLoad = file.toAbsolutePath();
        this.frame.output(Localization.lang("Opening", new String[0]) + ": '" + file + "'");
        String fileName = file.getFileName().toString();
        Globals.prefs.put("workingDirectory", fileToLoad.getParent().toString());
        if (FileBasedLock.hasLockFile(file)) {
            Optional<FileTime> modificationTime = FileBasedLock.getLockFileTimeStamp(file);
            if (modificationTime.isPresent() && System.currentTimeMillis() - modificationTime.get().toMillis() > 60000L) {
                int answer = JOptionPane.showConfirmDialog(null, "<html>" + Localization.lang("Error opening file", new String[0]) + " '" + fileName + "'. " + Localization.lang("File is locked by another JabRef instance.", new String[0]) + "<p>" + Localization.lang("Do you want to override the file lock?", new String[0]), Localization.lang("File locked", new String[0]), 0);
                if (answer != 0) return;
                FileBasedLock.deleteLockFile(file);
            } else if (!FileBasedLock.waitForFileLock(file)) {
                JOptionPane.showMessageDialog(null, Localization.lang("Error opening file", new String[0]) + " '" + fileName + "'. " + Localization.lang("File is locked by another JabRef instance.", new String[0]), Localization.lang("Error", new String[0]), 0);
                return;
            }
        }
        if (BackupManager.checkForBackupFile(fileToLoad)) {
            BackupUIManager.showRestoreBackupDialog(this.frame, fileToLoad);
        }
        if ((result = OpenDatabase.loadDatabase(fileToLoad.toString(), Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor())).getDatabase().isShared()) {
            try {
                new SharedDatabaseUIManager(this.frame).openSharedDatabaseFromParserResult(result);
            }
            catch (SQLException | InvalidDBMSConnectionPropertiesException | NotASharedDatabaseException | DatabaseNotSupportedException e) {
                result.getDatabaseContext().clearDatabaseFile();
                result.getDatabase().clearSharedDatabaseID();
                LOGGER.error("Connection error", e);
                JOptionPane.showMessageDialog(this.frame, e.getMessage() + "\n\n" + Localization.lang("A local copy will be opened.", new String[0]), Localization.lang("Connection error", new String[0]), 2);
            }
        }
        BasePanel panel = this.addNewDatabase(result, file, raisePanel);
        ParserResult finalReferenceToResult = result;
        SwingUtilities.invokeLater(() -> OpenDatabaseAction.performPostOpenActions(panel, finalReferenceToResult));
    }

    private BasePanel addNewDatabase(ParserResult result, Path file, boolean raisePanel) {
        BibDatabase database = result.getDatabase();
        if (result.hasWarnings()) {
            JabRefExecutorService.INSTANCE.execute(() -> ParserResultWarningDialog.showParserResultWarningDialog(result, this.frame));
        }
        BasePanel basePanel = new BasePanel(this.frame, result.getDatabaseContext());
        SwingUtilities.invokeLater(() -> this.frame.addTab(basePanel, raisePanel));
        if (Objects.nonNull(file)) {
            this.frame.output(Localization.lang("Opened library", new String[0]) + " '" + file.toString() + "' " + Localization.lang("with", new String[0]) + " " + database.getEntryCount() + " " + Localization.lang("entries", new String[0]) + ".");
        }
        return basePanel;
    }
}

