/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.BasePanelMode;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.actions.CopyDoiUrlAction;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditor;
import org.jabref.gui.externalfiletype.ExternalFileMenuItem;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.filelist.FileListEntry;
import org.jabref.gui.filelist.FileListTableModel;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableColumn;
import org.jabref.gui.menus.RightClickMenu;
import org.jabref.gui.specialfields.SpecialFieldMenuAction;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.specialfields.SpecialField;
import org.jabref.model.entry.specialfields.SpecialFieldValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTableSelectionListener
implements ListEventListener<BibEntry>,
MouseListener,
KeyListener,
FocusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainTableSelectionListener.class);
    private final MainTable table;
    private final BasePanel panel;
    private final EventList<BibEntry> tableRows;
    private final int[] lastPressed = new int[20];
    private PreviewPanel preview;
    private boolean workingOnPreview;
    private boolean enabled = true;
    private int lastPressedCount;
    private long lastPressedTime;

    public MainTableSelectionListener(BasePanel panel, MainTable table) {
        this.table = table;
        this.panel = panel;
        this.tableRows = table.getTableModel().getTableRows();
        this.preview = panel.getPreviewPanel();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void listChanged(ListEvent<BibEntry> e) {
        if (!this.enabled) {
            return;
        }
        EventList<BibEntry> selected = e.getSourceList();
        if (selected.isEmpty()) {
            return;
        }
        BibEntry newSelected = (BibEntry)selected.get(0);
        if ((this.panel.getMode() == BasePanelMode.SHOWING_EDITOR || this.panel.getMode() == BasePanelMode.WILL_SHOW_EDITOR) && this.panel.getEntryEditor() != null && newSelected == this.panel.getEntryEditor().getEntry()) {
            return;
        }
        if (newSelected != null) {
            BasePanelMode mode = this.panel.getMode();
            if (mode == BasePanelMode.WILL_SHOW_EDITOR || mode == BasePanelMode.SHOWING_EDITOR) {
                this.panel.showAndEdit(newSelected);
                SwingUtilities.invokeLater(() -> this.table.ensureVisible(this.table.getSelectedRow()));
            } else if (this.panel.getMode() == BasePanelMode.SHOWING_NOTHING || this.panel.getMode() == BasePanelMode.SHOWING_PREVIEW) {
                this.updatePreview(newSelected);
            }
        }
    }

    private void updatePreview(BibEntry toShow) {
        this.updatePreview(toShow, 0);
    }

    private void updatePreview(BibEntry toShow, int repeats) {
        if (this.workingOnPreview) {
            if (repeats > 0) {
                return;
            }
            Timer t = new Timer(50, actionEvent -> this.updatePreview(toShow, 1));
            t.setRepeats(false);
            t.start();
            return;
        }
        EventList<BibEntry> list = this.table.getSelected();
        if (list.size() != 1 || list.get(0) != toShow) {
            return;
        }
        this.workingOnPreview = true;
        SwingUtilities.invokeLater(() -> {
            this.panel.showPreview(toShow);
            this.workingOnPreview = false;
        });
    }

    public void editSignalled() {
        if (this.table.getSelected().size() == 1) {
            this.editSignalled((BibEntry)this.table.getSelected().get(0));
        }
    }

    public void editSignalled(BibEntry entry) {
        this.panel.showAndEdit(entry);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int col = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        int modelIndex = this.table.getColumnModel().getColumn(col).getModelIndex();
        MainTableColumn modelColumn = this.table.getMainTableColumn(modelIndex);
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (modelColumn == null || !modelColumn.isIconColumn()) {
                this.processPopupTrigger(e, row);
            } else {
                this.showIconRightClickMenu(e, row, modelColumn);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (e.getClickCount() == 2) {
            BibEntry toShow = (BibEntry)this.tableRows.get(row);
            this.editSignalled(toShow);
            return;
        }
        int col = this.table.columnAtPoint(e.getPoint());
        int modelIndex = this.table.getColumnModel().getColumn(col).getModelIndex();
        MainTableColumn modelColumn = this.table.getMainTableColumn(modelIndex);
        if (OS.WINDOWS && modelColumn.isIconColumn() && e.getButton() != 1) {
            return;
        }
        if (modelColumn.isIconColumn() && SpecialField.isSpecialField(modelColumn.getColumnName())) {
            this.handleSpecialFieldLeftClick(e, modelColumn.getColumnName());
        } else if (modelColumn.isIconColumn()) {
            Object value = this.table.getValueAt(row, col);
            if (value == null) {
                return;
            }
            BibEntry entry = (BibEntry)this.tableRows.get(row);
            List<String> fieldNames = modelColumn.getBibtexFields();
            JabRefExecutorService.INSTANCE.execute(() -> {
                this.panel.output(Localization.lang("External viewer called", new String[0]) + '.');
                for (String fieldName : fieldNames) {
                    if (!entry.hasField(fieldName)) continue;
                    String link = entry.getField(fieldName).get();
                    if (fieldName.equals("file")) {
                        FileListTableModel fileList = new FileListTableModel();
                        fileList.setContent(link);
                        FileListEntry flEntry = null;
                        if (modelColumn.isFileFilter()) {
                            for (int i = 0; i < fileList.getRowCount(); ++i) {
                                if (!fileList.getEntry(i).getType().toString().equals(modelColumn.getColumnName())) continue;
                                flEntry = fileList.getEntry(i);
                                break;
                            }
                        } else if (fileList.getRowCount() > 0) {
                            flEntry = fileList.getEntry(0);
                        }
                        if (flEntry == null) break;
                        ExternalFileMenuItem item = new ExternalFileMenuItem(this.panel.frame(), entry, "", flEntry.getLink(), (Icon)flEntry.getType().map(ExternalFileType::getIcon).orElse(null), this.panel.getBibDatabaseContext(), flEntry.getType());
                        item.doClick();
                        break;
                    }
                    try {
                        JabRefDesktop.openExternalViewer(this.panel.getBibDatabaseContext(), link, fieldName);
                    }
                    catch (IOException ex) {
                        this.panel.output(Localization.lang("Unable to open link.", new String[0]));
                        LOGGER.info("Unable to open link", ex);
                    }
                    break;
                }
            });
        } else if (modelColumn.getBibtexFields().contains("crossref")) {
            ((BibEntry)this.tableRows.get(row)).getField("crossref").ifPresent(crossref -> this.panel.getDatabase().getEntryByKey((String)crossref).ifPresent(entry -> this.panel.highlightEntry((BibEntry)entry)));
        }
        this.panel.frame().updateEnabledState();
    }

    private void handleSpecialFieldLeftClick(MouseEvent e, String columnName) {
        if (e.getClickCount() == 1) {
            SpecialField.getSpecialFieldInstanceFromFieldName(columnName).ifPresent(field2 -> {
                if (field2.isSingleValueField()) {
                    new SpecialFieldViewModel((SpecialField)((Object)field2)).getSpecialFieldAction(field2.getValues().get(0), this.panel.frame()).action();
                } else {
                    JPopupMenu menu = new JPopupMenu();
                    for (SpecialFieldValue val : field2.getValues()) {
                        menu.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(val), this.panel.frame()));
                    }
                    menu.show(this.table, e.getX(), e.getY());
                }
            });
        }
    }

    private void processPopupTrigger(MouseEvent e, int row) {
        int selRow = this.table.getSelectedRow();
        if (selRow == -1 || !this.table.isRowSelected(this.table.rowAtPoint(e.getPoint()))) {
            this.table.setRowSelectionInterval(row, row);
        }
        RightClickMenu rightClickMenu = new RightClickMenu(JabRefGUI.getMainFrame(), this.panel);
        rightClickMenu.show(this.table, e.getX(), e.getY());
    }

    private void showIconRightClickMenu(MouseEvent e, int row, MainTableColumn column) {
        BibEntry entry = (BibEntry)this.tableRows.get(row);
        JPopupMenu menu = new JPopupMenu();
        boolean showDefaultPopup = true;
        if (!column.getBibtexFields().isEmpty()) {
            for (String field2 : column.getBibtexFields()) {
                if ("file".equals(field2)) {
                    FileListTableModel fileList = new FileListTableModel();
                    entry.getField(field2).ifPresent(fileList::setContent);
                    for (int i = 0; i < fileList.getRowCount(); ++i) {
                        Optional<ExternalFileType> fileType;
                        FileListEntry flEntry = fileList.getEntry(i);
                        if (column.isFileFilter() && !flEntry.getType().get().getName().equalsIgnoreCase(column.getColumnName())) continue;
                        String description = flEntry.getDescription();
                        if (description == null || description.trim().isEmpty()) {
                            description = flEntry.getLink();
                        }
                        if (!(fileType = flEntry.getType()).isPresent()) {
                            String fileExtension = FileUtil.getFileExtension(flEntry.getLink()).orElse("");
                            fileType = Optional.of(new UnknownExternalFileType(fileExtension.toUpperCase(), fileExtension));
                        }
                        menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, description, flEntry.getLink(), fileType.get().getIcon(), this.panel.getBibDatabaseContext(), fileType));
                        showDefaultPopup = false;
                    }
                    continue;
                }
                if (SpecialField.isSpecialField(column.getColumnName())) {
                    showDefaultPopup = true;
                    continue;
                }
                Optional<String> content = entry.getField(field2);
                if (!content.isPresent()) continue;
                JLabel iconLabel = GUIGlobals.getTableIcon(field2);
                Icon icon = iconLabel == null ? IconTheme.JabRefIcon.FILE.getIcon() : iconLabel.getIcon();
                menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, content.get(), content.get(), icon, this.panel.getBibDatabaseContext(), field2));
                if (field2.equals("doi")) {
                    menu.add(new CopyDoiUrlAction(content.get()));
                }
                showDefaultPopup = false;
            }
            if (showDefaultPopup) {
                this.processPopupTrigger(e, row);
            } else {
                menu.show(this.table, e.getX(), e.getY());
            }
        }
    }

    public void entryEditorClosing(EntryEditor editor) {
        if (Globals.prefs.getPreviewPreferences().isPreviewPanelEnabled()) {
            this.panel.showPreview(editor.getEntry());
        } else {
            this.panel.hideBottomComponent();
            this.panel.adjustSplitter();
        }
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!e.isActionKey() && Character.isLetterOrDigit(e.getKeyChar()) && e.getModifiers() == 0) {
            int sortingColumn;
            long time = System.currentTimeMillis();
            long QUICK_JUMP_TIMEOUT = 2000L;
            if (time - this.lastPressedTime > 2000L) {
                this.lastPressedCount = 0;
            }
            this.lastPressedTime = time;
            char c = e.getKeyChar();
            if (this.lastPressedCount < this.lastPressed.length) {
                this.lastPressed[this.lastPressedCount] = c;
                ++this.lastPressedCount;
            }
            if ((sortingColumn = this.table.getSortingColumn(0)) == -1) {
                return;
            }
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                String s2;
                Object o = this.table.getValueAt(i, sortingColumn);
                if (o == null || (s2 = o.toString().toLowerCase(Locale.ROOT)).length() < this.lastPressedCount) continue;
                for (int j = 0; j < this.lastPressedCount && s2.charAt(j) == this.lastPressed[j]; ++j) {
                    if (j != this.lastPressedCount - 1) continue;
                    this.table.setRowSelectionInterval(i, i);
                    this.table.ensureVisible(i);
                    return;
                }
            }
        } else if (e.getKeyChar() == '\u001b') {
            this.lastPressedCount = 0;
        }
        this.panel.frame().updateEnabledState();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.lastPressedCount = 0;
    }

    public PreviewPanel getPreview() {
        return this.preview;
    }
}

