/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import java.util.List;
import java.util.Objects;
import org.jabref.Globals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.specialfields.SpecialFieldsUtils;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.specialfields.SpecialField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialFieldAction
implements BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialFieldAction.class);
    private final JabRefFrame frame;
    private final SpecialField specialField;
    private final String value;
    private final boolean nullFieldIfValueIsTheSame;
    private final String undoText;

    public SpecialFieldAction(JabRefFrame frame, SpecialField specialField, String value, boolean nullFieldIfValueIsTheSame, String undoText) {
        this.frame = frame;
        this.specialField = specialField;
        this.value = value;
        this.nullFieldIfValueIsTheSame = nullFieldIfValueIsTheSame;
        this.undoText = undoText;
    }

    @Override
    public void action() {
        try {
            List<BibEntry> bes = this.frame.getCurrentBasePanel().getSelectedEntries();
            if (bes == null || bes.isEmpty()) {
                return;
            }
            NamedCompound ce = new NamedCompound(this.undoText);
            for (BibEntry be : bes) {
                List<FieldChange> changes = SpecialFieldsUtils.updateField(this.specialField, this.value, be, this.nullFieldIfValueIsTheSame, Globals.prefs.isKeywordSyncEnabled(), Globals.prefs.getKeywordDelimiter());
                for (FieldChange change : changes) {
                    ce.addEdit(new UndoableFieldChange(change));
                }
            }
            ce.end();
            if (ce.hasEdits()) {
                this.frame.getCurrentBasePanel().getUndoManager().addEdit(ce);
                this.frame.getCurrentBasePanel().markBaseChanged();
                this.frame.getCurrentBasePanel().updateEntryEditorIfShowing();
                String outText = this.nullFieldIfValueIsTheSame || this.value == null ? this.getTextDone(this.specialField, Integer.toString(bes.size())) : this.getTextDone(this.specialField, this.value, Integer.toString(bes.size()));
                this.frame.output(outText);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Problem setting special fields", ex);
        }
    }

    private String getTextDone(SpecialField field2, String ... params) {
        Objects.requireNonNull(params);
        SpecialFieldViewModel viewModel = new SpecialFieldViewModel(field2);
        if (field2.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Toggled '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        if (!field2.isSingleValueField() && params.length == 2 && params[0] != null && params[1] != null) {
            String[] allParams = new String[]{viewModel.getLocalization(), params[0], params[1]};
            return Localization.lang("Set '%0' to '%1' for %2 entries", allParams);
        }
        if (!field2.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Cleared '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        LOGGER.info("Creation of special field status change message failed: illegal argument combination.");
        return "";
    }
}

