/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jabref.logic.l10n.Localization;

public class NamedCompound
extends CompoundEdit {
    private final String name;
    private boolean hasEdits;

    public NamedCompound(String name) {
        this.name = name;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        this.hasEdits = true;
        return super.addEdit(undoableEdit);
    }

    public boolean hasEdits() {
        return this.hasEdits;
    }

    @Override
    public String getUndoPresentationName() {
        return "<html>" + Localization.lang("Undo", new String[0]) + ": " + this.name + "<ul>" + this.getPresentationName() + "</ul></html>";
    }

    @Override
    public String getRedoPresentationName() {
        return "<html>" + Localization.lang("Redo", new String[0]) + ": " + this.name + "<ul>" + this.getPresentationName() + "</ul></html>";
    }

    @Override
    public String getPresentationName() {
        StringBuilder sb = new StringBuilder();
        for (UndoableEdit edit : this.edits) {
            sb.append("<li>").append(edit.getPresentationName());
        }
        return sb.toString();
    }
}

