/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.io.IOException;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import org.jabref.gui.AbstractView;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlHelper.class);

    public static void loadFXMLForControl(Parent control) {
        Class<?> clazz = control.getClass();
        String clazzName = clazz.getSimpleName();
        FXMLLoader fxmlLoader = new FXMLLoader(clazz.getResource(clazzName + ".fxml"), (ResourceBundle)Localization.getMessages());
        fxmlLoader.setController((Object)control);
        fxmlLoader.setRoot((Object)control);
        try {
            fxmlLoader.load();
            control.getStylesheets().add(0, (Object)AbstractView.class.getResource("Main.css").toExternalForm());
        }
        catch (IOException exception) {
            LOGGER.error("Problem loading fxml for control", exception);
        }
    }
}

