/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.worker;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.exporter.RtfTransferable;
import org.jabref.gui.fieldeditors.HtmlTransferable;
import org.jabref.gui.fieldeditors.XmlTransferable;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStyleGenerator;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitationStyleToClipboardWorker
extends SwingWorker<List<String>, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitationStyleToClipboardWorker.class);
    private final BasePanel basePanel;
    private final List<BibEntry> selectedEntries;
    private final String style;
    private final String previewStyle;
    private final CitationStyleOutputFormat outputFormat;

    public CitationStyleToClipboardWorker(BasePanel basePanel, CitationStyleOutputFormat outputFormat) {
        this.basePanel = basePanel;
        this.selectedEntries = basePanel.getSelectedEntries();
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
        this.style = previewPreferences.getPreviewCycle().get(previewPreferences.getPreviewCyclePosition());
        this.previewStyle = Globals.prefs.getPreviewPreferences().getPreviewStyle();
        this.outputFormat = outputFormat;
        basePanel.frame().setStatus(Localization.lang("Copying...", new String[0]));
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        String styleSource = null;
        if (CitationStyle.isCitationStyleFile(this.style)) {
            styleSource = CitationStyle.createCitationStyleFromFile(this.style).filter(citationStyleFromFile -> !citationStyleFromFile.getSource().isEmpty()).map(CitationStyle::getSource).orElse(null);
        }
        if (styleSource != null) {
            return CitationStyleGenerator.generateCitations(this.selectedEntries, styleSource, this.outputFormat);
        }
        StringReader sr = new StringReader(this.previewStyle.replace("__NEWLINE__", "\n"));
        LayoutFormatterPreferences layoutFormatterPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
        Layout layout = new LayoutHelper(sr, layoutFormatterPreferences).getLayoutFromText();
        ArrayList<String> citations = new ArrayList<String>(this.selectedEntries.size());
        for (BibEntry entry : this.selectedEntries) {
            citations.add(layout.doLayout(entry, this.basePanel.getDatabase()));
        }
        return citations;
    }

    @Override
    public void done() {
        try {
            List citations = (List)this.get();
            if (!CitationStyle.isCitationStyleFile(this.style)) {
                new ClipBoardManager().setTransferableClipboardContents(CitationStyleToClipboardWorker.processPreview(citations));
            } else {
                Transferable transferable;
                switch (this.outputFormat) {
                    case HTML: {
                        transferable = CitationStyleToClipboardWorker.processHtml(citations);
                        break;
                    }
                    case RTF: {
                        transferable = CitationStyleToClipboardWorker.processRtf(citations);
                        break;
                    }
                    case XSL_FO: {
                        transferable = CitationStyleToClipboardWorker.processXslFo(citations);
                        break;
                    }
                    case ASCII_DOC: 
                    case TEXT: {
                        transferable = CitationStyleToClipboardWorker.processText(citations);
                        break;
                    }
                    default: {
                        LOGGER.warn("unknown output format: '" + (Object)((Object)this.outputFormat) + "', processing it via the default.");
                        transferable = CitationStyleToClipboardWorker.processText(citations);
                    }
                }
                new ClipBoardManager().setTransferableClipboardContents(transferable);
            }
            this.basePanel.frame().setStatus(Localization.lang("Copied %0 citations.", String.valueOf(this.selectedEntries.size())));
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error while copying citations to the clipboard", e);
        }
    }

    protected static HtmlTransferable processPreview(List<String> citations) {
        String html = String.join((CharSequence)CitationStyleOutputFormat.HTML.getLineSeparator(), citations);
        return new HtmlTransferable(html);
    }

    protected static StringSelection processText(List<String> citations) {
        return new StringSelection(String.join((CharSequence)CitationStyleOutputFormat.TEXT.getLineSeparator(), citations));
    }

    protected static RtfTransferable processRtf(List<String> citations) {
        String result = "{\\rtf" + OS.NEWLINE + String.join((CharSequence)CitationStyleOutputFormat.RTF.getLineSeparator(), citations) + "}";
        return new RtfTransferable(result);
    }

    protected static XmlTransferable processXslFo(List<String> citations) {
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + OS.NEWLINE + "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">" + OS.NEWLINE + "   <fo:layout-master-set>" + OS.NEWLINE + "      <fo:simple-page-master master-name=\"citations\">" + OS.NEWLINE + "         <fo:region-body/>" + OS.NEWLINE + "      </fo:simple-page-master>" + OS.NEWLINE + "   </fo:layout-master-set>" + OS.NEWLINE + "   <fo:page-sequence master-reference=\"citations\">" + OS.NEWLINE + "      <fo:flow flow-name=\"xsl-region-body\">" + OS.NEWLINE + OS.NEWLINE;
        result = result + String.join((CharSequence)CitationStyleOutputFormat.XSL_FO.getLineSeparator(), citations);
        result = result + OS.NEWLINE + "      </fo:flow>" + OS.NEWLINE + "   </fo:page-sequence>" + OS.NEWLINE + "</fo:root>" + OS.NEWLINE;
        return new XmlTransferable(result);
    }

    protected static HtmlTransferable processHtml(List<String> citations) {
        String result = "<!DOCTYPE html>" + OS.NEWLINE + "<html>" + OS.NEWLINE + "   <head>" + OS.NEWLINE + "      <meta charset=\"utf-8\">" + OS.NEWLINE + "   </head>" + OS.NEWLINE + "   <body>" + OS.NEWLINE + OS.NEWLINE;
        result = result + String.join((CharSequence)CitationStyleOutputFormat.HTML.getLineSeparator(), citations);
        result = result + OS.NEWLINE + "   </body>" + OS.NEWLINE + "</html>" + OS.NEWLINE;
        return new HtmlTransferable(result);
    }
}

