/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.worker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.EntryMarker;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkEntriesAction
extends AbstractWorker
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkEntriesAction.class);
    private final JabRefFrame frame;
    private final int level;
    private final JMenuItem menuItem;
    private int besLength;

    public MarkEntriesAction(JabRefFrame frame, int level) {
        this.frame = frame;
        this.level = level;
        this.menuItem = new JMenuItem(Localization.lang("Level", new String[0]) + " " + level + "   ");
        this.menuItem.setMnemonic(String.valueOf(level + 1).charAt(0));
        this.menuItem.setBackground(Globals.prefs.getColor("markedEntryBackground" + this.level));
        this.menuItem.setOpaque(true);
        this.menuItem.addActionListener(this);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.init();
            this.getWorker().run();
            this.getCallBack().update();
        }
        catch (Throwable t) {
            LOGGER.warn("Problem marking entries", t);
        }
    }

    @Override
    public void run() {
        BasePanel panel = this.frame.getCurrentBasePanel();
        if (panel != null) {
            List<BibEntry> bes = panel.getSelectedEntries();
            this.besLength = bes.size();
            if (!bes.isEmpty()) {
                NamedCompound ce = new NamedCompound(Localization.lang("Mark entries", new String[0]));
                for (BibEntry be : bes) {
                    EntryMarker.markEntry(be, this.level + 1, false, ce);
                }
                ce.end();
                panel.getUndoManager().addEdit(ce);
            }
        }
    }

    @Override
    public void update() {
        String outputStr;
        switch (this.besLength) {
            case 0: {
                outputStr = Localization.lang("This operation requires one or more entries to be selected.", new String[0]);
                break;
            }
            case 1: {
                this.frame.getCurrentBasePanel().markBaseChanged();
                outputStr = Localization.lang("Marked selected entry", new String[0]);
                break;
            }
            default: {
                this.frame.getCurrentBasePanel().markBaseChanged();
                outputStr = Localization.lang("Marked all %0 selected entries", Integer.toString(this.besLength));
            }
        }
        this.frame.output(outputStr);
    }
}

