/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.jabref.logic.cleanup.DoiCleanup;
import org.jabref.logic.cleanup.MoveFieldCleanup;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.importer.EntryBasedParserFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.util.OS;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.DummyFileUpdateMonitor;

public class MathSciNet
implements SearchBasedParserFetcher,
EntryBasedParserFetcher,
IdBasedParserFetcher {
    private final ImportFormatPreferences preferences;

    public MathSciNet(ImportFormatPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    @Override
    public String getName() {
        return "MathSciNet";
    }

    @Override
    public URL getURLForEntry(BibEntry entry) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mrlookup");
        uriBuilder.addParameter("format", "bibtex");
        entry.getFieldOrAlias("title").ifPresent(title -> uriBuilder.addParameter("ti", (String)title));
        entry.getFieldOrAlias("author").ifPresent(author -> uriBuilder.addParameter("au", (String)author));
        entry.getFieldOrAlias("journal").ifPresent(journal -> uriBuilder.addParameter("jrnl", (String)journal));
        entry.getFieldOrAlias("year").ifPresent(year -> uriBuilder.addParameter("year", (String)year));
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForQuery(String query) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mathscinet/search/publications.html");
        uriBuilder.addParameter("pg7", "ALLF");
        uriBuilder.addParameter("s7", query);
        uriBuilder.addParameter("r", "1");
        uriBuilder.addParameter("extend", "1");
        uriBuilder.addParameter("fmt", "bibtex");
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://mathscinet.ams.org/mathscinet/search/publications.html");
        uriBuilder.addParameter("pg1", "MR");
        uriBuilder.addParameter("s1", identifier);
        uriBuilder.addParameter("fmt", "bibtex");
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            String response = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(OS.NEWLINE));
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
            BibtexParser bibtexParser = new BibtexParser(this.preferences, new DummyFileUpdateMonitor());
            Pattern pattern = Pattern.compile("<pre>(?s)(.*)</pre>");
            Matcher matcher = pattern.matcher(response);
            while (matcher.find()) {
                String bibtexEntryString = matcher.group();
                entries.addAll(bibtexParser.parseEntries(bibtexEntryString));
            }
            return entries;
        };
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        new MoveFieldCleanup("fjournal", "journal").cleanup(entry);
        new MoveFieldCleanup("mrclass", "keywords").cleanup(entry);
        new FieldFormatterCleanup("mrreviewer", new ClearFormatter()).cleanup(entry);
        new DoiCleanup().cleanup(entry);
        new FieldFormatterCleanup("url", new ClearFormatter()).cleanup(entry);
        entry.setCommentsBeforeEntry("");
    }
}

