/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.client;

import java.io.IOException;
import java.net.Socket;
import javafx.util.Pair;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.shared.Protocol;
import org.jabref.logic.remote.shared.RemoteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteClient.class);
    private static final int TIMEOUT = 2000;
    private int port;

    public RemoteClient(int port) {
        this.port = port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping() {
        try (Protocol protocol = this.openNewConnection();){
            protocol.sendMessage(RemoteMessage.PING);
            Pair<RemoteMessage, Object> response = protocol.receiveMessage();
            if (response.getKey() == RemoteMessage.PONG && "jabref".equals(response.getValue())) {
                boolean bl2 = true;
                return bl2;
            }
            String port = String.valueOf(this.port);
            String errorMessage = Localization.lang("Cannot use port %0 for remote operation; another application may be using it. Try specifying another port.", port);
            LOGGER.error(errorMessage);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Could not ping server at port " + this.port, e);
            return false;
        }
    }

    public boolean sendCommandLineArguments(String[] args) {
        boolean bl;
        block8: {
            Protocol protocol = this.openNewConnection();
            Throwable throwable = null;
            try {
                protocol.sendMessage(RemoteMessage.SEND_COMMAND_LINE_ARGUMENTS, args);
                Pair<RemoteMessage, Object> response = protocol.receiveMessage();
                boolean bl2 = bl = response.getKey() == RemoteMessage.OK;
                if (protocol == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (protocol != null) {
                            RemoteClient.$closeResource(throwable, protocol);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Could not send args " + String.join((CharSequence)", ", args) + " to the server at port " + this.port, e);
                    return false;
                }
            }
            RemoteClient.$closeResource(throwable, protocol);
        }
        return bl;
    }

    private Protocol openNewConnection() throws IOException {
        Socket socket = new Socket(RemotePreferences.getIpAddress(), this.port);
        socket.setSoTimeout(2000);
        return new Protocol(socket);
    }
}

