/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javafx.util.Pair;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.server.MessageHandler;
import org.jabref.logic.remote.shared.Protocol;
import org.jabref.logic.remote.shared.RemoteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteListenerServer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteListenerServer.class);
    private static final int BACKLOG = 1;
    private static final int ONE_SECOND_TIMEOUT = 1000;
    private final MessageHandler messageHandler;
    private final ServerSocket serverSocket;

    public RemoteListenerServer(MessageHandler messageHandler, int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 1, RemotePreferences.getIpAddress());
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            while (true) {
                if (Thread.interrupted()) break block18;
                try {
                    Socket socket = this.serverSocket.accept();
                    Throwable throwable = null;
                    try {
                        socket.setSoTimeout(1000);
                        try (Protocol protocol = new Protocol(socket);){
                            Pair<RemoteMessage, Object> input = protocol.receiveMessage();
                            this.handleMessage(protocol, (RemoteMessage)((Object)input.getKey()), input.getValue());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket == null) continue;
                        RemoteListenerServer.$closeResource(throwable, socket);
                    }
                }
                catch (SocketException ex) {
                    this.closeServerSocket();
                    return;
                }
                catch (IOException e) {
                    LOGGER.warn("RemoteListenerServer crashed", e);
                }
            }
            finally {
                this.closeServerSocket();
            }
        }
    }

    private void handleMessage(Protocol protocol, RemoteMessage type, Object argument) throws IOException {
        switch (type) {
            case PING: {
                protocol.sendMessage(RemoteMessage.PONG, "jabref");
                break;
            }
            case SEND_COMMAND_LINE_ARGUMENTS: {
                if (argument instanceof String[]) {
                    this.messageHandler.handleCommandLineArguments((String[])argument);
                    protocol.sendMessage(RemoteMessage.OK);
                    break;
                }
                throw new IOException("Argument for 'SEND_COMMAND_LINE_ARGUMENTS' is not of type String[]. Got " + argument);
            }
            default: {
                throw new IOException("Unhandled message to server " + (Object)((Object)type));
            }
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

