/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.util.Map;
import java.util.Optional;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.jabref.model.entry.BibEntry;

public class DocumentInformationExtractor {
    private final PDDocumentInformation documentInformation;
    private final BibEntry bibEntry;

    public DocumentInformationExtractor(PDDocumentInformation documentInformation) {
        this.documentInformation = documentInformation;
        this.bibEntry = new BibEntry();
    }

    private void extractAuthor() {
        String s2 = this.documentInformation.getAuthor();
        if (s2 != null) {
            this.bibEntry.setField("author", s2);
        }
    }

    private void extractTitle() {
        String s2 = this.documentInformation.getTitle();
        if (s2 != null) {
            this.bibEntry.setField("title", s2);
        }
    }

    private void extractKeywords() {
        String s2 = this.documentInformation.getKeywords();
        if (s2 != null) {
            this.bibEntry.setField("keywords", s2);
        }
    }

    private void extractSubject() {
        String s2 = this.documentInformation.getSubject();
        if (s2 != null) {
            this.bibEntry.setField("abstract", s2);
        }
    }

    private void extractOtherFields() {
        COSDictionary dict = this.documentInformation.getCOSObject();
        for (Map.Entry<COSName, COSBase> o : dict.entrySet()) {
            String key = o.getKey().getName();
            if (!key.startsWith("bibtex/")) continue;
            String value = dict.getString(key);
            if ("entrytype".equals(key = key.substring("bibtex/".length()))) {
                this.bibEntry.setType(value);
                continue;
            }
            this.bibEntry.setField(key, value);
        }
    }

    public Optional<BibEntry> extractBibtexEntry() {
        this.bibEntry.setType("misc");
        this.extractAuthor();
        this.extractTitle();
        this.extractKeywords();
        this.extractSubject();
        this.extractOtherFields();
        if (this.bibEntry.getFieldNames().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bibEntry);
    }
}

