/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbibtex.BibTeXComment;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXInclude;
import org.jbibtex.BibTeXObject;
import org.jbibtex.BibTeXPreamble;
import org.jbibtex.BibTeXString;
import org.jbibtex.Key;
import org.jbibtex.StringUtil;
import org.jbibtex.Value;

public class BibTeXFormatter {
    private String indent = "\t";

    public void format(BibTeXDatabase database, Writer writer) throws IOException {
        List<BibTeXObject> objects = database.getObjects();
        String separator = "";
        for (BibTeXObject object : objects) {
            writer.write(separator);
            if (object instanceof BibTeXComment) {
                this.format((BibTeXComment)object, writer);
            } else if (object instanceof BibTeXEntry) {
                this.format((BibTeXEntry)object, writer);
            } else if (object instanceof BibTeXInclude) {
                this.format((BibTeXInclude)object, writer);
            } else if (object instanceof BibTeXPreamble) {
                this.format((BibTeXPreamble)object, writer);
            } else if (object instanceof BibTeXString) {
                this.format((BibTeXString)object, writer);
            } else {
                throw new IllegalArgumentException();
            }
            separator = "\n\n";
        }
        writer.flush();
    }

    protected void format(BibTeXComment comment, Writer writer) throws IOException {
        writer.write("@Comment");
        this.format(comment.getValue(), 1, writer);
    }

    protected void format(BibTeXEntry entry, Writer writer) throws IOException {
        writer.write("@");
        this.format(entry.getType(), writer);
        writer.write(123);
        this.format(entry.getKey(), writer);
        writer.write(44);
        writer.write(10);
        Set<Map.Entry<Key, Value>> fields = entry.getFields().entrySet();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Map.Entry field2 = (Map.Entry)it.next();
            writer.write(this.getIndent());
            this.format((Key)field2.getKey(), writer);
            writer.write(" = ");
            this.format((Value)field2.getValue(), 2, writer);
            if (it.hasNext()) {
                writer.write(44);
            }
            writer.write(10);
        }
        writer.write(125);
    }

    protected void format(BibTeXInclude include, Writer writer) throws IOException {
        writer.write("@Include");
        this.format(include.getValue(), 1, writer);
    }

    protected void format(BibTeXPreamble preamble, Writer writer) throws IOException {
        writer.write("@Preamble");
        writer.write(123);
        this.format(preamble.getValue(), 1, writer);
        writer.write(125);
    }

    protected void format(BibTeXString string, Writer writer) throws IOException {
        writer.write("@String");
        writer.write(123);
        this.format(string.getKey(), writer);
        writer.write(" = ");
        this.format(string.getValue(), 1, writer);
        writer.write(125);
    }

    protected void format(Key key, Writer writer) throws IOException {
        String string = key.getValue();
        writer.write(string);
    }

    protected void format(Value value, int level, Writer writer) throws IOException {
        String string = StringUtil.addIndent(value.format(), level, this.getIndent());
        writer.write(string);
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }
}

