/* encodeErge.h was originally generated by the autoSql program, which also 
 * generated encodeErge.c and encodeErge.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ENCODEERGE_H
#define ENCODEERGE_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define ENCODEERGE_NUM_COLS 14

struct encodeErge
/* ENCODE experimental data from dbERGEII */
    {
    struct encodeErge *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of read - up to 255 characters */
    unsigned score;	/* Score from 0-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    unsigned blockCount;	/* Number of separate blocks (regions without gaps) */
    unsigned *blockSizes;	/* Comma separated list of block sizes */
    unsigned *chromStarts;	/* Start position of each block in relative to chromStart */
    char *Id;	/* dbERGEII Id */
    char *color;	/* RGB color values */
    };

struct encodeErge *encodeErgeLoad(char **row);
/* Load a encodeErge from row fetched with select * from encodeErge
 * from database.  Dispose of this with encodeErgeFree(). */

struct encodeErge *encodeErgeLoadAll(char *fileName);
/* Load all encodeErge from whitespace-separated file.
 * Dispose of this with encodeErgeFreeList(). */

struct encodeErge *encodeErgeLoadAllByChar(char *fileName, char chopper);
/* Load all encodeErge from chopper separated file.
 * Dispose of this with encodeErgeFreeList(). */

#define encodeErgeLoadAllByTab(a) encodeErgeLoadAllByChar(a, '\t');
/* Load all encodeErge from tab separated file.
 * Dispose of this with encodeErgeFreeList(). */

struct encodeErge *encodeErgeLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all encodeErge from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with encodeErgeFreeList(). */

void encodeErgeSaveToDb(struct sqlConnection *conn, struct encodeErge *el, char *tableName, int updateSize);
/* Save encodeErge as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use encodeErgeSaveToDbEscaped() */

void encodeErgeSaveToDbEscaped(struct sqlConnection *conn, struct encodeErge *el, char *tableName, int updateSize);
/* Save encodeErge as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than encodeErgeSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct encodeErge *encodeErgeCommaIn(char **pS, struct encodeErge *ret);
/* Create a encodeErge out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeErge */

void encodeErgeFree(struct encodeErge **pEl);
/* Free a single dynamically allocated encodeErge such as created
 * with encodeErgeLoad(). */

void encodeErgeFreeList(struct encodeErge **pList);
/* Free a list of dynamically allocated encodeErge's */

void encodeErgeOutput(struct encodeErge *el, FILE *f, char sep, char lastSep);
/* Print out encodeErge.  Separate fields with sep. Follow last field with lastSep. */

#define encodeErgeTabOut(el,f) encodeErgeOutput(el,f,'\t','\n');
/* Print out encodeErge as a line in a tab-separated file. */

#define encodeErgeCommaOut(el,f) encodeErgeOutput(el,f,',',',');
/* Print out encodeErge as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEERGE_H */

