/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.internal.styleeditor.StyleEditorDialog;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class StyleExtractor {
    private static int STYLE_INDEX = 1;

    private StyleExtractor() {
        throw new AssertionError();
    }

    public static IStyle extractStyleFrom(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        IStyled styleOwner = StyleExtractor.findStyleOwner(selectionProvider.getSelection());
        if (styleOwner == null) {
            return null;
        }
        IStyle sourceStyle = StyleExtractor.findSourceStyle(styleOwner);
        IStyle newStyle = null;
        newStyle = sourceStyle == null ? StyleExtractor.createUserStyle(editor, styleOwner) : StyleExtractor.importStyle(editor, styleOwner, sourceStyle);
        if (newStyle == null) {
            return null;
        }
        StyleExtractor.editStyle(newStyle, editor.getSite().getPage());
        return newStyle;
    }

    private static IStyled findStyleOwner(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof IStyled)) continue;
                return (IStyled)o;
            }
        }
        return null;
    }

    private static IStyle findSourceStyle(IStyled styleOwner) {
        if (styleOwner == null) {
            return null;
        }
        String styleId = styleOwner.getStyleId();
        if (styleId == null) {
            return null;
        }
        if (styleOwner instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)styleOwner).getOwnedWorkbook().getStyleSheet().findStyle(styleId);
        }
        return null;
    }

    private static IStyle createUserStyle(IEditorPart editor, IStyled styleOwner) {
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        IStyle newStyle = styleSheet.createStyle(styleOwner.getStyleType());
        IStyle defaultStyle = StyleExtractor.getDefaultStyle(editor, styleOwner);
        if (defaultStyle != null) {
            StyleExtractor.setProperties(newStyle, defaultStyle);
        }
        styleSheet.addStyle(newStyle, "normal-styles");
        newStyle.setName(NLS.bind((String)Messages.Style_name, (Object)STYLE_INDEX));
        ++STYLE_INDEX;
        MindMapUI.getResourceManager().saveUserStyleSheet();
        return newStyle;
    }

    private static void setProperties(IStyle newStyle, IStyle defaultStyle) {
        Iterator ps = defaultStyle.properties();
        while (ps.hasNext()) {
            Property next = (Property)ps.next();
            if (newStyle.getProperty(next.key) != null) continue;
            newStyle.setProperty(next.key, next.value);
        }
    }

    private static IStyle importStyle(IEditorPart editor, IStyled styleOwner, IStyle sourceStyle) {
        String oldName;
        IStyleSheet userStyleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        int oldSize = userStyleSheet.getAllStyles().size();
        IStyle newStyle = userStyleSheet.importStyle(sourceStyle);
        int newSize = userStyleSheet.getAllStyles().size();
        if (oldSize == newSize) {
            IStyle styleCreated = userStyleSheet.createStyle(sourceStyle.getType());
            Iterator properties = newStyle.properties();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                styleCreated.setProperty(property.key, property.value);
            }
            newStyle = styleCreated;
            userStyleSheet.addStyle(newStyle, "normal-styles");
        }
        if ((oldName = newStyle.getName()) == null || "".equals(oldName)) {
            newStyle.setName(NLS.bind((String)Messages.Style_name, (Object)STYLE_INDEX));
        }
        ++STYLE_INDEX;
        IStyle defaultStyle = StyleExtractor.getDefaultStyle(editor, styleOwner);
        if (defaultStyle != null) {
            StyleExtractor.setProperties(newStyle, defaultStyle);
        }
        MindMapUI.getResourceManager().saveUserStyleSheet();
        return newStyle;
    }

    private static IStyle getDefaultStyle(IEditorPart editor, IStyled styleOwner) {
        IMindMap mindmap = (IMindMap)MindMapUIPlugin.getAdapter((Object)editor, IMindMap.class);
        if (mindmap == null) {
            return null;
        }
        String family = MindMapUtils.getFamily((IStyled)styleOwner, (IMindMap)mindmap);
        IStyle theme = mindmap.getSheet().getTheme();
        if (theme == null) {
            return null;
        }
        IStyle style = theme.getDefaultStyle(family);
        return style;
    }

    private static void editStyle(IStyle style, IWorkbenchPage page) {
        new StyleEditorDialog(page.getWorkbenchWindow(), style).open();
    }
}

