/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

public class ModifyIdeaContentCommand
extends SourceCommand {
    private ITopic rootTopic;
    private ITopicExtensionElement modifiedIdea;
    private String content;
    private String oldContent;
    private int index = -1;

    public ModifyIdeaContentCommand(ITopic rootTopic, ITopicExtensionElement modifiedIdea, String content) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.modifiedIdea = modifiedIdea;
        this.content = content == null ? "" : content;
        this.setLabel(IdeaFactoryMessages.ModifyIdeaContentCommand_Modify_Idea_Content);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.oldContent == null) {
            this.oldContent = this.modifiedIdea.getTextContent();
            this.index = ((ITopicExtensionElement)this.modifiedIdea.getParent()).getChildren("idea").indexOf(this.modifiedIdea);
        }
        this.modifiedIdea.setTextContent(this.content);
        this.fireCoreEvent(this.rootTopic, "ideaModified");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.oldContent != null) {
            this.modifiedIdea.setTextContent(this.oldContent);
            this.fireCoreEvent(this.rootTopic, "ideaModified");
        }
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.modifiedIdea, this.index);
        }
    }
}

