/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.ResourceExportWizardConfirmPage;
import org.xmind.ui.internal.xmindresource.ResourceExportWizardSelectionPage;
import org.xmind.ui.internal.xmindresource.XMindResourceImpExpUtils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractExportWizard;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

public class ResourceExportWizard
extends AbstractExportWizard
implements IPageChangedListener {
    private static final String SECTION_NAME = "org.xmind.ui.xmindresource.ResourceExportWizad";
    private ResourceExportWizardSelectionPage selectionPage;
    private ResourceExportWizardConfirmPage confirmPage;

    public ResourceExportWizard() {
        this.setWindowTitle(Messages.ResourceExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(XMindResourcePlugin.getDefault().getDialogSettings(SECTION_NAME));
    }

    public void addPages() {
        this.selectionPage = new ResourceExportWizardSelectionPage();
        this.addPage((IWizardPage)this.selectionPage);
        this.confirmPage = new ResourceExportWizardConfirmPage();
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.selectionPage != null && !this.selectionPage.getElementsToExport().isEmpty();
    }

    public boolean performFinish() {
        boolean[] b = new boolean[1];
        if (this.hasTargetPath()) {
            Shell shell = this.getShell();
            List<Object> elementsToExport = this.selectionPage.getElementsToExport();
            if (!elementsToExport.isEmpty()) {
                int status;
                int index;
                int result;
                String targetPath = this.getTargetPath();
                if (!targetPath.endsWith(".xrb") && (result = new MessageDialog(shell, Messages.ResourceExportWizard_Dialog_UncompatibleFormat_title, null, NLS.bind((String)Messages.ResourceExportWizard_Dialog_UncompatibleFormat_description, (Object)targetPath.substring(index = targetPath.indexOf(46)), (Object)".xrb"), 3, new String[]{Messages.ResourceExportWizard_Dialog_Yes_button, Messages.ResourceExportWizard_Dialog_No_button}, 0).open()) != 0) {
                    return b[0];
                }
                if (!this.isOverwriteWithoutPrompt() && new File(targetPath).exists() && !DialogUtils.confirmOverwrite((Shell)this.getShell(), (String)this.getTargetPath())) {
                    return false;
                }
                File parentFile = new File(targetPath).getParentFile();
                if (parentFile != null && !parentFile.isDirectory()) {
                    result = new MessageDialog(shell, Messages.ResourceExportWizard_Dialog_PathNotExist_title, null, NLS.bind((String)Messages.ResourceExportWizard_Dialog_PathNotExist_description, (Object)parentFile.getAbsolutePath()), 3, new String[]{Messages.ResourceExportWizard_Dialog_Yes_button, Messages.ResourceExportWizard_Dialog_No_button}, 0).open();
                    if (result == 0) {
                        parentFile.mkdirs();
                    } else {
                        return b[0];
                    }
                }
                if ((status = XMindResourceImpExpUtils.exportResourceBundle(elementsToExport, this.getTargetPath())) != 0) {
                    MessageDialog information = new MessageDialog(shell, Messages.ResourceExportWizard_Exception_Information_Title, null, Messages.ResourceExportWizard_WholeException_Information_description, 2, new String[]{Messages.ResourceExportWizard_Exception_Informtion_buntton}, 0);
                    information.setBlockOnOpen(false);
                    information.open();
                    b[0] = false;
                } else {
                    b[0] = true;
                }
                String dir = new File(this.getTargetPath()).getParent();
                Program.launch((String)dir);
            }
        }
        return b[0];
    }

    public void pageChanged(PageChangedEvent event) {
        if (this.selectionPage != null && this.confirmPage != null && event.getSelectedPage() == this.confirmPage) {
            this.confirmPage.setNeedConfirmSelection(this.selectionPage.getElementsToExport());
        }
    }

    protected String getSuggestedFileName() {
        return String.valueOf(Messages.ResourceImportExportWizardPage_SuggestedName) + ".xrb";
    }
}

