/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.e4handlers.DialogPartHandler;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneeMComboViewer;
import org.xmind.ui.internal.taskinfo.AssigneeSheetManager;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.DateInfoPickerViewer;
import org.xmind.ui.internal.taskinfo.DependencyViewer;
import org.xmind.ui.internal.taskinfo.DurationEditor;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.EditableValueViewer;
import org.xmind.ui.internal.taskinfo.ITaskInfoViewer;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.resources.ImageDescriptorProvider;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.util.TextFormatter;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;
import org.xmind.ui.viewers.SliderViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfoViewer
implements ITaskInfoViewer,
ICoreEventListener {
    private static final String SHOW_GANTT_COMMAND = "org.xmind.ui.command.showDialogPart";
    private static final String COMMAND_NAME = "org.xmind.ui.commandParameter.modelPart.partId";
    private static final String COMMAND_VALUE = "org.xmind.ui.dialogPart.gantt";
    private static final Object NONE = new Object();
    private ScrolledForm contentPane;
    private ITopic topic;
    private ICommandStack commandStack;
    private RotatableWrapLabel taskNameText;
    private Button checkPointWidget;
    private WidgetFactory factory;
    private AssigneeMComboViewer assigneeCombo;
    private MComboViewer priorityCombo;
    private MComboViewer progressCombo;
    private SliderViewer progressSlider;
    private DateInfoPickerViewer startDatePicker;
    private DurationViewer durationViewer;
    private EndDateViewer endDateViewer;
    private Hyperlink clearAllLink;
    private Hyperlink backLink;
    private Color invalidColor;
    private Color validColor;
    private ICoreEventRegister register;
    private boolean refreshingPriority = false;
    private boolean refreshingProgress = false;
    private boolean refreshingDates = false;
    private List<Object> defaultProgressComboInput = null;
    private int tempPercentage = -1;
    private Set<String> assignees = null;
    private DependencyViewer dependencyViewer = null;
    private Stack<ITopic> jumpStack = new Stack();
    private List<Runnable> taskChangedListeners = new ArrayList<Runnable>(1);
    private ResourceManager resources;

    public void createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.factory = new WidgetFactory(parent.getDisplay());
        this.factory.setBackground(parent.getBackground());
        this.factory.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.createContentPane(parent);
        this.hookControl(this.getControl());
    }

    @Override
    public ITopic getTask() {
        return this.topic;
    }

    private void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskInfoViewer.this.handleDispose();
            }
        });
    }

    private void createContentPane(Composite parent) {
        this.createTitleSection(parent);
        this.invalidColor = parent.getDisplay().getSystemColor(16);
        this.validColor = parent.getDisplay().getSystemColor(2);
        this.contentPane = this.factory.createScrolledForm(parent);
        this.addHorizontalScrollSupport(this.contentPane);
        this.contentPane.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 10;
        this.contentPane.getBody().setLayout((Layout)layout);
        this.createContents(this.contentPane.getBody());
    }

    private void addHorizontalScrollSupport(final ScrolledForm form) {
        if (Util.isWindows()) {
            form.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!form.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point origin = form.getOrigin();
                        form.setOrigin(origin.x + offset, origin.y);
                    }
                }
            });
        }
    }

    private void createContents(Composite parent) {
        Composite container = this.factory.createComposite(parent);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout((Layout)gridLayout);
        this.createPropertySections(container);
        this.createBackLink(parent);
        this.createClearAllLink(parent);
        this.createGanttLink(parent);
    }

    private void createPropertySections(Composite parent) {
        Color bg1 = this.factory.getColors().getBackground();
        Color bg2 = this.factory.getColors().createColor("alternativeBackground", 232, 238, 248);
        this.factory.setBackground(bg1);
        Composite composite = this.createContainer(parent);
        this.createAssignedToSection(composite);
        this.factory.setBackground(bg2);
        composite = this.createContainer(parent);
        this.createPrioritySection(composite);
        this.factory.setBackground(bg1);
        composite = this.createContainer(parent);
        this.createStartDateSection(composite);
        this.factory.setBackground(bg2);
        composite = this.createContainer(parent);
        this.createDurationSection(composite);
        this.factory.setBackground(bg1);
        composite = this.createContainer(parent);
        this.createEndDateSection(composite);
        this.factory.setBackground(bg2);
        composite = this.createContainer(parent);
        this.createProgressSection(composite);
        this.factory.setBackground(bg1);
        composite = this.createContainer(parent);
        this.createCheckPointSection(composite);
        this.factory.setBackground(bg2);
        composite = this.createContainer(parent);
        this.createDependencyViewer(composite);
        this.factory.setBackground(bg1);
        this.refresh();
    }

    private void createDependencyViewer(Composite parent) {
        this.dependencyViewer = new DependencyViewer();
        this.dependencyViewer.setInputProvider(this);
        this.dependencyViewer.createControl(parent, this.factory);
        this.dependencyViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.dependencyViewer.getControl().getLayoutData()).widthHint = 1;
    }

    private Composite createContainer(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    private void createTitleSection(Composite parent) {
        final Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 0;
        gridLayout.marginWidth = 7;
        gridLayout.horizontalSpacing = 7;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        this.createTitleLabel(composite);
        Label sep = new Label(composite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.taskNameText.setBackgroundColor(parent.getBackground());
        this.taskNameText.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])JFaceResources.getDefaultFont().getFontData(), (int)3))));
        this.refreshTitle();
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TaskInfoViewer.this.taskNameText.setPrefWidth(composite.getSize().x - 14);
            }
        });
    }

    private void createTitleLabel(Composite parent) {
        FigureCanvas canvas = new FigureCanvas(parent);
        canvas.setLayoutData((Object)new GridData(4, 4, true, false));
        canvas.setVisible(true);
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setBackground(parent.getParent().getBackground());
        this.taskNameText = new RotatableWrapLabel(0);
        this.taskNameText.setSingleLine(true);
        this.taskNameText.setAbbreviated(true);
        canvas.setContents((IFigure)this.taskNameText);
    }

    private void createStartDateSection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.StartDate_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.startDatePicker = new DateInfoPickerViewer(composite);
        this.startDatePicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.startDatePicker.setInvalidColor(this.getInvalidForeground());
        this.startDatePicker.setValidColor(this.getValidForeground());
        this.startDatePicker.refresh();
        this.startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskInfoViewer.this.refreshingDates || TaskInfoViewer.this.getTask() == null) {
                    return;
                }
                DateInfo startTime = (DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement();
                TaskInfoViewer.this.changeStartDate(startTime);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (TaskInfoViewer.this.startDatePicker.getDatePicker() != null) {
                            TaskInfoViewer.this.startDatePicker.getDatePicker().close();
                        }
                    }
                });
            }
        });
    }

    private void createDurationSection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.Duration_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.durationViewer = new DurationViewer(composite);
        this.durationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createEndDateSection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.EndDate_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.endDateViewer = new EndDateViewer(composite);
        this.endDateViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createAssignedToSection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.AssignedTo_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.assigneeCombo = new AssigneeMComboViewer(composite, 1024, true, this.getTask());
        this.assigneeCombo.setEmptySelectionImitation(this);
        this.assigneeCombo.getControl().setBackground(parent.getBackground());
        this.assigneeCombo.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.assigneeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assigneeCombo.setLabelProvider((IBaseLabelProvider)new AssignComboLabelProvider());
        this.assigneeCombo.setPatternFilter(new PopupFilteredList.PatternFilter());
        this.assigneeCombo.setInput(this.getAssigneeComboInput());
        this.assigneeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskInfoViewer.this.topic == null) {
                    return;
                }
                Object ele = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (ele == "org.xmind.ui.internal.taskinfo.assignee.none") {
                    TaskInfoViewer.this.changeAssaigee(null);
                } else {
                    TaskInfoViewer.this.changeAssaigee(ele);
                }
            }
        });
        this.assigneeCombo.setPermitsUnprovidedElement(true);
    }

    private void createProgressSection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.Progress_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.progressCombo = new MComboViewer(composite, 1024);
        this.progressCombo.setEmptySelectionImitation((Object)this);
        this.progressCombo.getControl().setBackground(parent.getBackground());
        this.progressCombo.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.progressCombo.setLabelProvider((IBaseLabelProvider)new ProgressComboLabelProvider());
        this.progressCombo.setPatternFilter((PopupFilteredList.PatternFilter)new ProgressPatternFilter());
        this.progressCombo.setInput(this.getDefaultProgressComboInput());
        this.progressCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskInfoViewer.this.refreshingProgress || TaskInfoViewer.this.tempPercentage >= 0 || TaskInfoViewer.this.topic == null) {
                    return;
                }
                TaskInfoViewer.this.changeProgressByMarker(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.progressCombo.setPermitsUnprovidedElement(true);
        this.progressSlider = new SliderViewer(composite, 256);
        this.progressSlider.getControl().setBackground(parent.getBackground());
        this.progressSlider.setContentProvider((IContentProvider)new ProgressSliderContentProvider());
        this.progressSlider.setLabelProvider((IBaseLabelProvider)new ProgressSliderLabelProvider());
        GridData progressSliderLayoutData = new GridData(4, 4, true, false);
        progressSliderLayoutData.horizontalSpan = 2;
        progressSliderLayoutData.widthHint = 50;
        this.progressSlider.getControl().setLayoutData((Object)progressSliderLayoutData);
        this.progressSlider.setInput((Object)this);
        this.progressSlider.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskInfoViewer.this.tempPercentage = -1;
                if (TaskInfoViewer.this.refreshingProgress || TaskInfoViewer.this.topic == null) {
                    return;
                }
                TaskInfoViewer.this.changeProgressByPercentage(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.progressSlider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskInfoViewer.this.refreshingProgress || TaskInfoViewer.this.topic == null) {
                    return;
                }
                TaskInfoViewer.this.setTempProgress((Integer)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void createPrioritySection(Composite parent) {
        Composite composite = this.factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = this.factory.createLabel(composite, TaskMessages.Priority_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.priorityCombo = new MComboViewer(composite, 0);
        this.priorityCombo.getControl().setBackground(parent.getBackground());
        this.priorityCombo.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.priorityCombo.setLabelProvider((IBaseLabelProvider)new PriorityLabelProvider());
        this.priorityCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.priorityCombo.setEmptySelectionImitation((Object)this);
        ArrayList<Object> input = new ArrayList<Object>(MindMapUI.getResourceManager().getSystemMarkerSheet().findMarkerGroup("priorityMarkers").getMarkers());
        input.add(0, NONE);
        this.priorityCombo.setInput(input);
        this.priorityCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskInfoViewer.this.refreshingPriority || TaskInfoViewer.this.topic == null) {
                    return;
                }
                TaskInfoViewer.this.changePriorityMarker(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void createCheckPointSection(Composite parent) {
        this.checkPointWidget = new Button(parent, 32);
        this.factory.adapt((Control)this.checkPointWidget, true, true);
        this.checkPointWidget.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.checkPointWidget.setText(TaskMessages.CheckPoint_label);
        this.checkPointWidget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TaskInfoViewer.this.topic == null) {
                    return;
                }
                TaskInfoViewer.this.changeCheckPoint(TaskInfoViewer.this.checkPointWidget.getSelection());
                VerifyUI20141031.getUsageDataCollector().increase("TaskInfoClickCheckPointCount");
            }
        });
    }

    private void createBackLink(Composite parent) {
        this.backLink = this.factory.createHyperlink(parent, "", 0);
        this.backLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskInfoViewer.this.goBack();
            }
        });
        this.backLink.setVisible(false);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.exclude = true;
        layoutData.widthHint = 226;
        this.backLink.setLayoutData((Object)layoutData);
        this.backLink.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])JFaceResources.getDefaultFont().getFontData(), (int)-1))));
    }

    private void createClearAllLink(Composite parent) {
        this.clearAllLink = this.factory.createHyperlink(parent, TaskMessages.ClearAll_text, 0);
        this.clearAllLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskInfoViewer.this.clearAll();
            }
        });
        this.clearAllLink.setFont(this.resources.createFont(JFaceResources.getDefaultFontDescriptor().increaseHeight(-1)));
        this.clearAllLink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
    }

    private void createGanttLink(Composite parent) {
        Hyperlink ganttLink = this.factory.createHyperlink(parent, TaskMessages.GanttLink_text, 0);
        ganttLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                TaskInfoViewer.this.showGanttView();
            }
        });
        ganttLink.setFont(this.resources.createFont(JFaceResources.getDefaultFontDescriptor().increaseHeight(-1)));
        ganttLink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
    }

    protected void handleDispose() {
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
    }

    public Control getControl() {
        return this.contentPane;
    }

    public void setTask(ITopic topic) {
        ITopic oldTopic = this.topic;
        this.topic = topic;
        this.inputChanged(topic, oldTopic);
        this.fireTaskChanged();
    }

    private void inputChanged(ITopic newTopic, ITopic oldTopic) {
        IWorkbook newWorkbook;
        if (this.register != null) {
            this.register.unregisterAll();
        } else {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        if (newTopic != null) {
            this.register.setNextSourceFrom((Object)newTopic);
            this.register.register("titleText");
            this.register.register("markerRefAdd");
            this.register.register("markerRefRemove");
            this.register.register("taskInfoChange");
        }
        if (this.assigneeCombo != null && !this.assigneeCombo.getControl().isDisposed()) {
            this.assigneeCombo.setTopic(newTopic);
        }
        IWorkbook oldWorkbook = oldTopic == null ? null : oldTopic.getOwnedWorkbook();
        IWorkbook iWorkbook = newWorkbook = newTopic == null ? null : newTopic.getOwnedWorkbook();
        if (oldWorkbook != newWorkbook) {
            this.assignees = null;
        }
        this.refresh();
    }

    public void setCommandStack(ICommandStack commandStack) {
        this.commandStack = commandStack;
    }

    @Override
    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setFocus() {
        if (this.contentPane != null && !this.contentPane.isDisposed()) {
            this.contentPane.setFocus();
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.getDisplay().syncExec(new Runnable(){

            public void run() {
                String type = event.getType();
                if ("titleText".equals(type)) {
                    TaskInfoViewer.this.refreshTitle();
                } else if ("markerRefAdd".equals(type) || "markerRefRemove".equals(type)) {
                    TaskInfoViewer.this.refreshProgress();
                    TaskInfoViewer.this.refreshPriority();
                    TaskInfoViewer.this.refreshTitle();
                } else if ("taskInfoChange".equals(type)) {
                    TaskInfoViewer.this.refresh();
                }
            }
        });
    }

    public void refresh() {
        this.refreshTitle();
        this.refreshAssign();
        this.refreshDates();
        this.refreshProgress();
        this.refreshPriority();
        this.refreshCheckPoint();
        this.refreshBackLink();
        this.refreshClearAllLink();
        this.refreshDependencies();
        this.reflow();
    }

    private void reflow() {
        if (this.contentPane != null && !this.contentPane.isDisposed()) {
            this.contentPane.reflow(true);
        }
    }

    private void refreshDependencies() {
        if (this.dependencyViewer != null && this.dependencyViewer.getControl() != null && !this.dependencyViewer.getControl().isDisposed()) {
            this.dependencyViewer.refresh();
        }
    }

    private void refreshBackLink() {
        if (this.backLink != null && !this.backLink.isDisposed()) {
            boolean newExclude;
            boolean oldExclude = ((GridData)this.backLink.getLayoutData()).exclude;
            if (this.jumpStack.isEmpty()) {
                this.backLink.setVisible(false);
                newExclude = true;
            } else {
                this.backLink.setText(NLS.bind((String)TaskMessages.GoBack_text, (Object)this.jumpStack.peek().getTitleText()));
                this.backLink.setVisible(true);
                newExclude = false;
            }
            if (newExclude != oldExclude) {
                ((GridData)this.backLink.getLayoutData()).exclude = newExclude;
                this.backLink.getParent().layout(true);
            }
        }
    }

    private void refreshClearAllLink() {
        if (this.clearAllLink != null && !this.clearAllLink.isDisposed()) {
            this.clearAllLink.setEnabled(this.topic != null);
        }
    }

    private void refreshTitle() {
        Color color;
        String title;
        if (this.taskNameText == null) {
            return;
        }
        if (this.topic != null) {
            title = NLS.bind((String)TaskMessages.TaskName_pattern, (Object)TextFormatter.removeNewLineCharacter((String)this.topic.getTitleText()));
            color = this.validColor;
        } else {
            title = NLS.bind((String)TaskMessages.TaskName_pattern, (Object)TaskMessages.TaskName_NoTask);
            color = Display.getCurrent().getSystemColor(15);
        }
        this.taskNameText.setForegroundColor(color);
        this.taskNameText.setEnabled(true);
        this.taskNameText.setText(title);
    }

    private void refreshAssign() {
        this.assignees = null;
        if (this.assigneeCombo == null || this.assigneeCombo.getControl().isDisposed()) {
            return;
        }
        String content = TaskInfoUtils.getContent(this.topic, "assigned-to");
        this.assigneeCombo.setInput(this.getAssigneeComboInput());
        this.assigneeCombo.setSelection((ISelection)(content == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)content)));
        this.assigneeCombo.setEnabled(this.topic != null);
    }

    private void refreshDates() {
        if (this.startDatePicker == null || this.startDatePicker.getControl().isDisposed() || this.durationViewer == null || this.durationViewer.getControl().isDisposed() || this.endDateViewer == null || this.endDateViewer.getControl().isDisposed()) {
            return;
        }
        this.refreshingDates = true;
        boolean enabled = this.getTask() != null;
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(this.getTask());
        this.startDatePicker.setSelection((ISelection)(startDate == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)startDate)));
        this.startDatePicker.setEnabled(enabled);
        DurationInfo userDuration = TaskInfoUtils.getDurationInfo(this.getTask());
        this.durationViewer.getEditor().getButton().setTextForeground(startDate == null && userDuration == null ? this.getInvalidForeground() : this.getValidForeground());
        DurationInfo duration = TaskInfoUtils.calculateDurationExcludeWeekends(this.getTask());
        this.durationViewer.getEditor().getButton().setText(duration.toString());
        this.durationViewer.getEditor().setDays(duration.getDays());
        this.durationViewer.getEditor().setHours(duration.getHours());
        this.durationViewer.setEnabled(enabled);
        this.durationViewer.getDisplay().setText(duration.toString());
        DateInfo endDate = TaskInfoUtils.calculateEndDateInfo(this.getTask());
        this.endDateViewer.getDatePicker().setSelection((ISelection)(endDate == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)endDate)));
        this.endDateViewer.setEnabled(enabled);
        this.endDateViewer.getEditLink().setEnabled(enabled && startDate != null);
        this.endDateViewer.getDisplay().setText(endDate == null ? TaskMessages.NoDate_text : TaskInfoUtils.formatDateAndTime(endDate.date));
        DateInfo userEndDate = TaskInfoUtils.getEndDateInfo(this.getTask());
        boolean showDuration = userEndDate == null;
        this.durationViewer.setEditorVisible(showDuration);
        this.endDateViewer.setEditorVisible(!showDuration);
        this.refreshingDates = false;
    }

    private void setTempProgress(int percentage) {
        if (this.progressCombo == null || this.progressCombo.getControl().isDisposed()) {
            return;
        }
        this.tempPercentage = percentage;
        IMarker marker = TaskInfoUtils.findPercentageMarker(percentage, true);
        ProgressItem item = new ProgressItem(marker, percentage);
        this.progressCombo.setInput(this.createProgressComboInput(item));
        this.progressCombo.setSelection((ISelection)new StructuredSelection((Object)item));
    }

    private void refreshProgress() {
        if (this.progressCombo == null || this.progressCombo.getControl().isDisposed() || this.progressSlider == null || this.progressSlider.getControl().isDisposed()) {
            return;
        }
        this.refreshingProgress = true;
        IMarker marker = TaskInfoUtils.findMarker(this.topic, "taskMakers");
        if (marker != null) {
            int percentage;
            String markerId = marker.getId();
            if (markerId.equals(TaskInfoUtils.getPercentageMarkerId(percentage = this.getCurrentPercentage(), true))) {
                if (markerId.equals(TaskInfoUtils.getPercentageMarkerId(percentage, false))) {
                    this.progressCombo.setInput(this.getDefaultProgressComboInput());
                    this.progressCombo.setSelection((ISelection)new StructuredSelection((Object)marker));
                } else {
                    ProgressItem item = new ProgressItem(marker, percentage);
                    this.progressCombo.setInput(this.createProgressComboInput(item));
                    this.progressCombo.setSelection((ISelection)new StructuredSelection((Object)item));
                }
            } else {
                percentage = TaskInfoUtils.getPercentage(markerId);
                this.progressCombo.setInput(this.getDefaultProgressComboInput());
                this.progressCombo.setSelection((ISelection)new StructuredSelection((Object)marker));
            }
            this.progressSlider.setSelection((ISelection)new StructuredSelection((Object)percentage));
        } else {
            this.progressCombo.setInput(this.getDefaultProgressComboInput());
            this.progressCombo.setSelection((ISelection)StructuredSelection.EMPTY);
            this.progressSlider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        boolean enabled = this.topic != null;
        this.progressCombo.setEnabled(enabled);
        this.progressSlider.getControl().setEnabled(enabled);
        this.refreshingProgress = false;
    }

    private int getCurrentPercentage() {
        return TaskInfoUtils.getProgress(this.topic);
    }

    private Object createProgressComboInput(ProgressItem item) {
        ArrayList<Object> list = new ArrayList<Object>(this.getDefaultProgressComboInput());
        list.add(0, item);
        return list;
    }

    private List<Object> getDefaultProgressComboInput() {
        if (this.defaultProgressComboInput == null) {
            IMarkerSheet sheet = MindMapUI.getResourceManager().getSystemMarkerSheet();
            this.defaultProgressComboInput = new ArrayList<Object>(sheet.findMarkerGroup("taskMakers").getMarkers());
            this.defaultProgressComboInput.remove(sheet.findMarker("task-pause"));
            this.defaultProgressComboInput.add(0, NONE);
        }
        return this.defaultProgressComboInput;
    }

    private List<String> getAssigneeComboInput() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.assignees == null) {
            this.assignees = this.topic != null ? TaskInfoUtils.loadAllAssignees(this.topic.getOwnedWorkbook()) : new TreeSet<String>();
            if (this.getFrequencyAssignees() != null) {
                this.assignees.addAll(this.getFrequencyAssignees());
            }
        }
        list.addAll(this.assignees);
        return list;
    }

    private Collection<String> getFrequencyAssignees() {
        TreeSet<AssigneeItem> list = AssigneeSheetManager.getInstance().getAssigneeSheet().getAssignees();
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeSet<String> assignees = new TreeSet<String>();
        for (AssigneeItem item : list) {
            assignees.add(item.getName());
        }
        return assignees;
    }

    private void refreshPriority() {
        if (this.priorityCombo == null || this.priorityCombo.getControl().isDisposed()) {
            return;
        }
        this.refreshingPriority = true;
        IMarker priorityMarker = TaskInfoUtils.findMarker(this.topic, "priorityMarkers");
        if (priorityMarker == null) {
            this.priorityCombo.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.priorityCombo.setSelection((ISelection)new StructuredSelection((Object)priorityMarker));
        }
        this.priorityCombo.setEnabled(this.topic != null);
        this.refreshingPriority = false;
    }

    private void refreshCheckPoint() {
        if (this.checkPointWidget == null || this.checkPointWidget.isDisposed()) {
            return;
        }
        boolean isCheckPoint = TaskInfoUtils.getCheckPoint(this.topic);
        this.checkPointWidget.setSelection(isCheckPoint);
        this.checkPointWidget.setEnabled(this.topic != null);
    }

    private void changeStartDate(DateInfo date) {
        TaskInfoUtils.changeStartDate(this.getTask(), this.getCommandStack(), date);
    }

    private void changeEndDate(DateInfo date) {
        TaskInfoUtils.changeEndDate(this.getTask(), this.getCommandStack(), date);
    }

    private void changeDuration() {
        int days = this.durationViewer.getEditor().getDays();
        int hours = this.durationViewer.getEditor().getHours();
        int weeks = 0;
        int totalHours = days * 24 + hours;
        int deltaNotFullWeekendsHours = 0;
        DateInfo startDate = TaskInfoUtils.getStartDateInfo(this.topic);
        if (startDate != null) {
            Calendar start = Calendar.getInstance();
            start.setTimeInMillis(startDate.date.getTimeInMillis());
            int startDayOfWeek = start.get(7);
            if (startDayOfWeek == 7 || startDayOfWeek == 1) {
                Calendar start2 = Calendar.getInstance();
                start2.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
                start2.getTime();
                start2.set(7, 2);
                if (start2.before(start)) {
                    start2.add(3, 1);
                }
                deltaNotFullWeekendsHours = (int)((start2.getTimeInMillis() - start.getTimeInMillis()) / 1000L / 3600L);
                start.setTimeInMillis(start2.getTimeInMillis());
            }
            Calendar saturday = Calendar.getInstance();
            saturday.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
            saturday.getTime();
            saturday.set(7, 7);
            if (saturday.before(start)) {
                saturday.add(3, 1);
            }
            int deltaHours = (int)((saturday.getTimeInMillis() - start.getTimeInMillis()) / 1000L / 3600L);
            totalHours -= (deltaHours += (int)((saturday.getTimeInMillis() - start.getTimeInMillis()) / 1000L % 3600L) == 0 ? 0 : 1);
            while (totalHours > 0) {
                ++weeks;
                totalHours -= 120;
            }
        }
        days += weeks * 2;
        hours += deltaNotFullWeekendsHours;
        while (hours > 23) {
            hours -= 24;
            ++days;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        DurationInfo duration = days == 0 && hours == 0 ? null : new DurationInfo(days, hours);
        TaskInfoUtils.changeDuration(this.getTask(), this.getCommandStack(), duration);
    }

    private void changeDurationActive(boolean active) {
        TaskInfoUtils.changeDurationActive(this.getTask(), this.getCommandStack(), active);
        if (active) {
            this.durationViewer.setFocus();
        } else {
            this.endDateViewer.setFocus();
        }
    }

    private void changeAssaigee(Object ele) {
        String assignee = (String)ele;
        if (assignee == null || "".equals(assignee.trim())) {
            TaskInfoUtils.changeAssigned(this.topic, this.commandStack, null);
            return;
        }
        TaskInfoUtils.changeAssigned(this.topic, this.commandStack, (String)ele);
        if (this.assignees != null) {
            this.assignees.add(assignee);
        }
        this.assigneeCombo.update(this.getAssigneeComboInput(), null);
    }

    private void changePriorityMarker(Object ele) {
        if (ele == NONE) {
            TaskInfoUtils.changePriorityMarker(this.topic, this.commandStack, null);
        } else if (ele instanceof IMarker) {
            TaskInfoUtils.changePriorityMarker(this.topic, this.commandStack, (IMarker)ele);
        }
    }

    private void changeCheckPoint(boolean value) {
        TaskInfoUtils.changeCheckPoint(this.topic, this.commandStack, value);
    }

    private void changeProgressByMarker(Object selection) {
        if (selection == NONE) {
            this.deleteProgress();
        } else if (selection instanceof IMarker) {
            if (this.commandStack == null || this.topic == null) {
                return;
            }
            IMarker marker = (IMarker)selection;
            String markerId = marker.getId();
            int percentage = TaskInfoUtils.getPercentage(markerId);
            this.changeProgress(percentage, marker);
        } else {
            this.changeProgressByPercentage(selection);
        }
    }

    private void changeProgressByPercentage(Object selection) {
        if (selection instanceof String) {
            String string = (String)selection;
            int i = string.indexOf(37);
            if (i >= 0) {
                string = string.substring(0, i);
            }
            string = string.trim();
            try {
                int percentage = Integer.parseInt(string);
                this.changeProgress(percentage);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (selection instanceof Integer) {
            this.changeProgress((Integer)selection);
        }
    }

    private void changeProgress(int value) {
        this.changeProgress(value, TaskInfoUtils.findPercentageMarker(value, true));
    }

    private void changeProgress(int value, IMarker marker) {
        TaskInfoUtils.changeProgress(this.topic, this.commandStack, value, marker);
    }

    private void deleteProgress() {
        TaskInfoUtils.deleteProgress(this.topic, this.commandStack);
    }

    private void clearAll() {
        TaskInfoUtils.clearTaskInfo(this.topic, this.commandStack);
    }

    private void showGanttView() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            ECommandService commandService = (ECommandService)window.getService(ECommandService.class);
            EHandlerService handlerService = (EHandlerService)window.getService(EHandlerService.class);
            if (commandService == null || handlerService == null) {
                return;
            }
            Command command = commandService.getCommand(SHOW_GANTT_COMMAND);
            HashMap<String, String> paramters = new HashMap<String, String>();
            paramters.put(COMMAND_NAME, COMMAND_VALUE);
            if (!command.isDefined()) {
                return;
            }
            ParameterizedCommand myCommand = commandService.createCommand(SHOW_GANTT_COMMAND, paramters);
            handlerService.activateHandler(SHOW_GANTT_COMMAND, (Object)new DialogPartHandler());
            if (!handlerService.canExecute(myCommand)) {
                return;
            }
            handlerService.executeHandler(myCommand);
        }
    }

    @Override
    public void jumpTo(ITopic task) {
        this.jumpStack.push(this.getTask());
        this.setTask(task);
    }

    private void goBack() {
        ITopic newTask = this.jumpStack.pop();
        if (newTask != null) {
            this.setTask(newTask);
            if (this.dependencyViewer != null) {
                this.dependencyViewer.setFocus();
            }
        }
    }

    public void addTaskChangedListener(Runnable listener) {
        this.taskChangedListeners.add(listener);
    }

    public void removeTaskChangedListener(Runnable listener) {
        this.taskChangedListeners.remove(listener);
    }

    private void fireTaskChanged() {
        Object[] objectArray = this.taskChangedListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((Runnable)listener).run();
                }
            });
            ++n2;
        }
    }

    @Override
    public Color getInvalidForeground() {
        return this.invalidColor;
    }

    @Override
    public Color getValidForeground() {
        return this.validColor;
    }

    protected ResourceManager getResourceManager() {
        return this.resources;
    }

    private class AssignComboLabelProvider
    extends ImageCachedLabelProvider
    implements IColorProvider,
    ImageDescriptorProvider {
        private AssignComboLabelProvider() {
        }

        protected Image createImage(Object element) {
            if (element instanceof String && !element.equals("org.xmind.ui.internal.taskinfo.assignee.none")) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/assignee.png").createImage();
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            if (element instanceof String && !element.equals("org.xmind.ui.internal.taskinfo.assignee.none")) {
                return TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/assignee.png");
            }
            return null;
        }

        public String getText(Object element) {
            if (element == NONE) {
                return TaskMessages.NoneAssignCombo_text;
            }
            if (element == "org.xmind.ui.internal.taskinfo.assignee.none") {
                return TaskMessages.NoneAssignCombo_text;
            }
            if (element == TaskInfoViewer.this) {
                return TaskMessages.EnterAssignCombo_text;
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskInfoViewer.this) {
                return TaskInfoViewer.this.invalidColor;
            }
            return TaskInfoViewer.this.validColor;
        }
    }

    private class DurationViewer
    extends EditableValueViewer {
        private DurationEditor editor;

        public DurationViewer(Composite parent) {
            super(parent);
        }

        protected void editLinkActivated() {
            if (TaskInfoViewer.this.getTask() == null) {
                return;
            }
            TaskInfoViewer.this.changeDurationActive(true);
            this.editor.startEditing();
        }

        protected void createEditor(Composite parent) {
            this.editor = new DurationEditor(parent);
            this.editor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.editor.addEditorListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                }

                public void cancelEditor() {
                    TaskInfoViewer.this.refresh();
                }

                public void applyEditorValue() {
                    TaskInfoViewer.this.changeDuration();
                }
            });
        }

        protected void setEditorFocus() {
            this.editor.setFocus();
        }

        public DurationEditor getEditor() {
            return this.editor;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.editor.setEnabled(enabled);
        }
    }

    private class EndDateViewer
    extends EditableValueViewer {
        private DateInfoPickerViewer endDatePicker;

        public EndDateViewer(Composite parent) {
            super(parent);
        }

        protected void editLinkActivated() {
            TaskInfoViewer.this.changeDurationActive(false);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (EndDateViewer.this.endDatePicker.getControl().isDisposed()) {
                        return;
                    }
                    EndDateViewer.this.endDatePicker.openDatePicker();
                }
            });
        }

        protected void createEditor(Composite parent) {
            this.endDatePicker = new DateInfoPickerViewer(parent);
            this.endDatePicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.endDatePicker.setInvalidColor(TaskInfoViewer.this.getInvalidForeground());
            this.endDatePicker.setValidColor(TaskInfoViewer.this.getValidForeground());
            this.endDatePicker.refresh();
            this.endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (TaskInfoViewer.this.refreshingDates || TaskInfoViewer.this.getTask() == null) {
                        return;
                    }
                    DateInfo dateInfo = (DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement();
                    TaskInfoViewer.this.changeEndDate(dateInfo);
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            if (EndDateViewer.this.endDatePicker.getDatePicker() != null) {
                                EndDateViewer.this.endDatePicker.getDatePicker().close();
                            }
                        }
                    });
                }
            });
        }

        protected void setEditorFocus() {
            this.endDatePicker.getControl().setFocus();
        }

        public DateInfoPickerViewer getDatePicker() {
            return this.endDatePicker;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.endDatePicker.setEnabled(enabled);
        }
    }

    private class MarkerLabelProvider
    extends ImageCachedLabelProvider
    implements ImageDescriptorProvider {
        private MarkerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IMarker) {
                ISheet sheet;
                if (TaskInfoViewer.this.topic != null && (sheet = TaskInfoViewer.this.topic.getOwnedSheet()) != null) {
                    return sheet.getLegend().getMarkerDescription(((IMarker)element).getId());
                }
                return ((IMarker)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            if (element instanceof IMarker) {
                return TaskInfoViewer.this.getResourceManager().createImage(MarkerImageDescriptor.createFromMarker((IMarker)((IMarker)element)));
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            if (element instanceof IMarker) {
                return MarkerImageDescriptor.createFromMarker((IMarker)((IMarker)element));
            }
            return null;
        }
    }

    private class PriorityLabelProvider
    extends MarkerLabelProvider
    implements IColorProvider {
        private PriorityLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NONE) {
                return TaskMessages.NonePriority_text;
            }
            if (element == TaskInfoViewer.this) {
                return TaskMessages.SelectPriority_text;
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskInfoViewer.this) {
                return TaskInfoViewer.this.invalidColor;
            }
            return TaskInfoViewer.this.validColor;
        }
    }

    private class ProgressComboLabelProvider
    extends MarkerLabelProvider
    implements IColorProvider {
        private ProgressComboLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ProgressItem) {
                element = ((ProgressItem)element).marker;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element == NONE) {
                return TaskMessages.NoneProgress_text;
            }
            if (element == TaskInfoViewer.this) {
                return TaskMessages.EnterProgress_text;
            }
            if (element instanceof IMarker) {
                String text = super.getText(element);
                int percentage = TaskInfoUtils.getPercentage(((IMarker)element).getId());
                return NLS.bind((String)"{0} - {1}%", (Object)text, (Object)percentage);
            }
            if (element instanceof ProgressItem) {
                return NLS.bind((String)"{0}%", (Object)((ProgressItem)element).percentage);
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskInfoViewer.this) {
                return TaskInfoViewer.this.invalidColor;
            }
            return TaskInfoViewer.this.validColor;
        }
    }

    private static class ProgressItem {
        IMarker marker;
        int percentage;

        public ProgressItem(IMarker marker, int value) {
            this.marker = marker;
            this.percentage = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ProgressItem)) {
                return false;
            }
            ProgressItem that = (ProgressItem)obj;
            return this.marker.equals(that.marker) && this.percentage == that.percentage;
        }
    }

    private class ProgressPatternFilter
    extends PopupFilteredList.PatternFilter {
        private ProgressPatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String pattern = this.getPatternText();
            if (pattern != null) {
                int index = pattern.indexOf(37);
                if (index >= 0) {
                    pattern = pattern.substring(0, index);
                }
                pattern = pattern.trim();
                int percentage = -1;
                try {
                    percentage = Integer.parseInt(pattern);
                }
                catch (NumberFormatException numberFormatException) {}
                if (percentage >= 0 && percentage <= 100 && element instanceof IMarker) {
                    String id = ((IMarker)element).getId();
                    return id.equals(TaskInfoUtils.getPercentageMarkerId(percentage, true));
                }
            }
            return super.select(viewer, parentElement, element);
        }
    }

    private class ProgressSliderContentProvider
    implements ISliderContentProvider {
        private ProgressSliderContentProvider() {
        }

        public double getRatio(Object input, Object value) {
            return (double)((Integer)value).intValue() / 100.0;
        }

        public Object getValue(Object input, double ratio) {
            return (int)(ratio * 100.0);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ProgressSliderLabelProvider
    extends LabelProvider {
        private ProgressSliderLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Integer) {
                return NLS.bind((String)"{0} %", (Object)element);
            }
            return super.getText(element);
        }
    }
}

