/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;

public class Bullet {
    public int type;
    public StyleRange style;
    public String text;
    int[] linesIndices;
    int count;

    public Bullet(StyleRange style) {
        this(1, style);
    }

    public Bullet(int type, StyleRange style) {
        if (style == null) {
            SWT.error(4);
        }
        if (style.metrics == null) {
            SWT.error(4);
        }
        this.type = type;
        this.style = style;
    }

    void addIndices(int startLine, int lineCount) {
        if (this.linesIndices == null) {
            this.linesIndices = new int[lineCount];
            this.count = lineCount;
            for (int i = 0; i < lineCount; ++i) {
                this.linesIndices[i] = startLine + i;
            }
        } else {
            int modifyEnd;
            int modifyStart;
            for (modifyStart = 0; modifyStart < this.count && startLine > this.linesIndices[modifyStart]; ++modifyStart) {
            }
            for (modifyEnd = modifyStart; modifyEnd < this.count && startLine + lineCount > this.linesIndices[modifyEnd]; ++modifyEnd) {
            }
            int newSize = modifyStart + lineCount + this.count - modifyEnd;
            if (newSize > this.linesIndices.length) {
                int[] newLinesIndices = new int[newSize];
                System.arraycopy(this.linesIndices, 0, newLinesIndices, 0, this.count);
                this.linesIndices = newLinesIndices;
            }
            System.arraycopy(this.linesIndices, modifyEnd, this.linesIndices, modifyStart + lineCount, this.count - modifyEnd);
            for (int i = 0; i < lineCount; ++i) {
                this.linesIndices[modifyStart + i] = startLine + i;
            }
            this.count = newSize;
        }
    }

    int indexOf(int lineIndex) {
        for (int i = 0; i < this.count; ++i) {
            if (this.linesIndices[i] != lineIndex) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        return this.style.hashCode() ^ this.type;
    }

    int[] removeIndices(int startLine, int replaceLineCount, int newLineCount, boolean update) {
        int i;
        if (this.count == 0) {
            return null;
        }
        if (startLine > this.linesIndices[this.count - 1]) {
            return null;
        }
        int endLine = startLine + replaceLineCount;
        int delta = newLineCount - replaceLineCount;
        for (i = 0; i < this.count; ++i) {
            int j;
            int index = this.linesIndices[i];
            if (startLine > index) continue;
            for (j = i; j < this.count && this.linesIndices[j] < endLine; ++j) {
            }
            if (update) {
                int k = j;
                while (k < this.count) {
                    int n = k++;
                    this.linesIndices[n] = this.linesIndices[n] + delta;
                }
            }
            int[] redrawLines = new int[this.count - j];
            System.arraycopy(this.linesIndices, j, redrawLines, 0, this.count - j);
            System.arraycopy(this.linesIndices, j, this.linesIndices, i, this.count - j);
            this.count -= j - i;
            return redrawLines;
        }
        i = 0;
        while (i < this.count) {
            int n = i++;
            this.linesIndices[n] = this.linesIndices[n] + delta;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

