/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractValidatingNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultUnlockedConfiguration;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyFactory;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationCreationRequest;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.DefaultRootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.artifacts.configurations.NoContextRoleBasedConfigurationCreationRequest;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.GradleVersion;

public class DefaultConfigurationContainer
extends AbstractValidatingNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private static final Pattern RESERVED_NAMES_FOR_DETACHED_CONFS = Pattern.compile("detachedConfiguration\\d*");
    private static final Set<ConfigurationRole> VALID_MAYBE_CREATE_ROLES = new HashSet<ConfigurationRole>(Arrays.asList(ConfigurationRoles.CONSUMABLE, ConfigurationRoles.RESOLVABLE, ConfigurationRoles.DEPENDENCY_SCOPE, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE));
    private final AtomicInteger detachedConfigurationDefaultNameCounter = new AtomicInteger(1);
    private final Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfigurationContainer(Instantiator instantiator, CollectionCallbackActionDecorator callbackDecorator, DefaultRootComponentMetadataBuilder.Factory rootComponentMetadataBuilderFactory, DefaultConfigurationFactory defaultConfigurationFactory, ResolutionStrategyFactory resolutionStrategyFactory) {
        super(Configuration.class, instantiator, (Namer)new Configuration.Namer(), callbackDecorator);
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilderFactory.create(this);
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.getEventRegister().registerLazyAddAction(x -> this.rootComponentMetadataBuilder.getValidator().validateMutation(MutationValidator.MutationType.HIERARCHY));
        this.whenObjectRemoved(x -> this.rootComponentMetadataBuilder.getValidator().validateMutation(MutationValidator.MutationType.HIERARCHY));
    }

    protected Configuration doCreate(String name) {
        DefaultConfigurationContainer.validateNameIsAllowed(name);
        return this.defaultConfigurationFactory.create(name, this, this.resolutionStrategyFactory, this.rootComponentMetadataBuilder, ConfigurationRoles.LEGACY);
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public Set<? extends ConfigurationInternal> getAll() {
        Set set = (Set)Cast.uncheckedCast((Object)this);
        return ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public void visitAll(Consumer<ConfigurationInternal> visitor) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            visitor.accept((ConfigurationInternal)configuration);
        }
    }

    @Override
    public ConfigurationInternal findByName(String name) {
        return (ConfigurationInternal)super.findByName(name);
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    public String getTypeDisplayName() {
        return "configuration";
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = this.nextDetachedConfigurationName();
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder componentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(detachedConfigurationsProvider);
        DefaultUnlockedConfiguration detachedConfiguration = this.defaultConfigurationFactory.create(name, detachedConfigurationsProvider, this.resolutionStrategyFactory, componentMetadataBuilder, ConfigurationRolesForMigration.LEGACY_TO_RESOLVABLE_DEPENDENCY_SCOPE);
        this.copyAllTo(detachedConfiguration, dependencies);
        detachedConfigurationsProvider.setTheOnlyConfiguration(detachedConfiguration);
        return detachedConfiguration;
    }

    private String nextDetachedConfigurationName() {
        return DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter.getAndIncrement();
    }

    private void copyAllTo(DefaultConfiguration detachedConfiguration, Dependency[] dependencies) {
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add((Object)dependency.copy());
        }
    }

    public NamedDomainObjectProvider<ResolvableConfiguration> resolvable(String name) {
        this.assertMutable("resolvable(String)");
        return this.registerResolvableConfiguration(name, (Action<? super ResolvableConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<ResolvableConfiguration> resolvable(String name, Action<? super ResolvableConfiguration> action) {
        this.assertMutable("resolvableUnlocked(String, Action)");
        return this.registerResolvableConfiguration(name, action);
    }

    public Configuration resolvableUnlocked(String name) {
        this.assertMutable("resolvableUnlocked(String)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.RESOLVABLE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration resolvableUnlocked(String name, Action<? super Configuration> action) {
        this.assertMutable("resolvableUnlocked(String, Action)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.RESOLVABLE, action);
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> consumable(String name) {
        this.assertMutable("consumable(String)");
        return this.registerConsumableConfiguration(name, (Action<? super ConsumableConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> consumable(String name, Action<? super ConsumableConfiguration> action) {
        this.assertMutable("consumable(String, Action)");
        return this.registerConsumableConfiguration(name, action);
    }

    public Configuration consumableUnlocked(String name) {
        this.assertMutable("consumableUnlocked(String)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.CONSUMABLE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration consumableUnlocked(String name, Action<? super Configuration> action) {
        this.assertMutable("consumableUnlocked(String, Action)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.CONSUMABLE, action);
    }

    public NamedDomainObjectProvider<DependencyScopeConfiguration> dependencyScope(String name) {
        this.assertMutable("dependencyScope(String)");
        return this.registerDependencyScopeConfiguration(name, (Action<? super DependencyScopeConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<DependencyScopeConfiguration> dependencyScope(String name, Action<? super DependencyScopeConfiguration> action) {
        this.assertMutable("dependencyScope(String, Action)");
        return this.registerDependencyScopeConfiguration(name, action);
    }

    public Configuration dependencyScopeUnlocked(String name) {
        this.assertMutable("dependencyScopeUnlocked(String)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.DEPENDENCY_SCOPE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration dependencyScopeUnlocked(String name, Action<? super Configuration> action) {
        this.assertMutable("dependencyScopeUnlocked(String, Action)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.DEPENDENCY_SCOPE, action);
    }

    @Deprecated
    public Configuration resolvableDependencyScopeUnlocked(String name) {
        this.assertMutable("resolvableDependencyScopeUnlocked(String)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, (Action<? super Configuration>)Actions.doNothing());
    }

    @Deprecated
    public Configuration resolvableDependencyScopeUnlocked(String name, Action<? super Configuration> action) {
        this.assertMutable("resolvableDependencyScopeUnlocked(String, Action)");
        return this.createUnlockedConfiguration(name, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, action);
    }

    public Configuration migratingUnlocked(String name, ConfigurationRole role) {
        this.assertMutable("migratingUnlocked(String, ConfigurationRole)");
        return this.migratingUnlocked(name, role, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration migratingUnlocked(String name, ConfigurationRole role, Action<? super Configuration> action) {
        this.assertMutable("migratingUnlocked(String, ConfigurationRole, Action)");
        if (ConfigurationRolesForMigration.ALL.contains(role)) {
            return this.createUnlockedConfiguration(name, role, action);
        }
        throw new InvalidUserDataException("Unknown migration role: " + role);
    }

    public Configuration maybeCreateResolvableUnlocked(String name) {
        return this.doMaybeCreate(new NoContextRoleBasedConfigurationCreationRequest(name, ConfigurationRoles.RESOLVABLE), true);
    }

    public Configuration maybeCreateConsumableUnlocked(String name) {
        return this.doMaybeCreate(new NoContextRoleBasedConfigurationCreationRequest(name, ConfigurationRoles.CONSUMABLE), true);
    }

    public Configuration maybeCreateDependencyScopeUnlocked(String name) {
        return this.maybeCreateDependencyScopeUnlocked(name, true);
    }

    public Configuration maybeCreateDependencyScopeUnlocked(String name, boolean verifyPrexisting) {
        return this.doMaybeCreate(new NoContextRoleBasedConfigurationCreationRequest(name, ConfigurationRoles.DEPENDENCY_SCOPE), verifyPrexisting);
    }

    public Configuration maybeCreateMigratingUnlocked(String name, ConfigurationRole role) {
        NoContextRoleBasedConfigurationCreationRequest request = new NoContextRoleBasedConfigurationCreationRequest(name, role);
        ConfigurationInternal conf = this.findByName(request.getConfigurationName());
        if (null != conf) {
            return request.verifyExistingConfigurationUsage(conf);
        }
        return this.migratingUnlocked(request.getConfigurationName(), request.getRole());
    }

    @Deprecated
    public Configuration maybeCreateResolvableDependencyScopeUnlocked(String name) {
        return this.maybeCreate(new NoContextRoleBasedConfigurationCreationRequest(name, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE));
    }

    public Configuration maybeCreate(RoleBasedConfigurationCreationRequest request) {
        return this.doMaybeCreate(request, true);
    }

    private Configuration doMaybeCreate(RoleBasedConfigurationCreationRequest request, boolean verifyPrexisting) {
        ConfigurationInternal conf = this.findByName(request.getConfigurationName());
        if (null != conf) {
            if (verifyPrexisting) {
                return request.verifyExistingConfigurationUsage((Configuration)conf);
            }
            return this.getByName(request.getConfigurationName());
        }
        if (VALID_MAYBE_CREATE_ROLES.contains(request.getRole())) {
            return this.createUnlockedConfiguration(request.getConfigurationName(), request.getRole(), (Action<? super Configuration>)Actions.doNothing());
        }
        throw new GradleException("Cannot maybe create invalid role: " + request.getRole());
    }

    private NamedDomainObjectProvider<ConsumableConfiguration> registerConsumableConfiguration(String name, Action<? super ConsumableConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, ConsumableConfiguration.class, n -> this.defaultConfigurationFactory.createConsumable(name, this, this.resolutionStrategyFactory, this.rootComponentMetadataBuilder));
    }

    private NamedDomainObjectProvider<ResolvableConfiguration> registerResolvableConfiguration(String name, Action<? super ResolvableConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, ResolvableConfiguration.class, n -> this.defaultConfigurationFactory.createResolvable(name, this, this.resolutionStrategyFactory, this.rootComponentMetadataBuilder));
    }

    private NamedDomainObjectProvider<DependencyScopeConfiguration> registerDependencyScopeConfiguration(String name, Action<? super DependencyScopeConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, DependencyScopeConfiguration.class, n -> this.defaultConfigurationFactory.createDependencyScope(name, this, this.resolutionStrategyFactory, this.rootComponentMetadataBuilder));
    }

    private Configuration createUnlockedConfiguration(String name, ConfigurationRole role, Action<? super Configuration> configureAction) {
        assert (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"9.0")) < 0 || role == ConfigurationRoles.LEGACY);
        this.assertCanAdd(name);
        DefaultConfigurationContainer.validateNameIsAllowed(name);
        DefaultUnlockedConfiguration configuration = this.defaultConfigurationFactory.create(name, this, this.resolutionStrategyFactory, this.rootComponentMetadataBuilder, role);
        this.add(configuration);
        configureAction.execute((Object)configuration);
        return configuration;
    }

    private <T extends Configuration> NamedDomainObjectProvider<T> registerConfiguration(String name, Action<? super T> configureAction, Class<T> publicType, Function<String, T> factory) {
        this.assertCanAdd(name);
        DefaultConfigurationContainer.validateNameIsAllowed(name);
        NamedDomainObjectProvider configuration = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, publicType, configureAction, factory}));
        this.addLater((Provider)configuration);
        return configuration;
    }

    private static void validateNameIsAllowed(String name) {
        if (RESERVED_NAMES_FOR_DETACHED_CONFS.matcher(name).matches()) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Creating a configuration with a name that starts with 'detachedConfiguration'").withAdvice(String.format("Use a different name for the configuration '%s'.", name))).willBeRemovedInGradle9().withUpgradeGuideSection(8, "reserved_configuration_names")).nagUser();
        }
    }

    public class NamedDomainObjectCreatingProvider<I extends Configuration>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I> {
        private final Function<String, I> factory;

        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction, Function<String, I> factory) {
            super((DefaultNamedDomainObjectCollection)DefaultConfigurationContainer.this, name, type, configureAction);
            this.factory = factory;
        }

        protected I createDomainObject() {
            return (I)((Configuration)this.factory.apply(this.getName()));
        }
    }
}

