#define LZMA_API_STATIC
#define LZMA_API(type) type

#include <lzma.h>
#include <stdlib.h>
#include <string.h>

extern "C" {

extern LZMA_API(const char *) _lzma_version_string(void) lzma_nothrow lzma_attr_const;
extern const char * lzma_version_string(void) lzma_nothrow lzma_attr_const { return _lzma_version_string(); }

extern LZMA_API(lzma_ret) _lzma_code(lzma_stream *strm, lzma_action action) lzma_nothrow lzma_attr_warn_unused_result;
extern lzma_ret lzma_code(lzma_stream *strm, lzma_action action) lzma_nothrow { return _lzma_code(strm, action); }

extern LZMA_API(void) _lzma_end(lzma_stream *strm) lzma_nothrow;
extern void lzma_end(lzma_stream *strm) lzma_nothrow { _lzma_end(strm); }

extern LZMA_API(lzma_ret) _lzma_easy_encoder(lzma_stream *strm, uint32_t preset, lzma_check check) lzma_nothrow lzma_attr_warn_unused_result;
extern lzma_ret lzma_easy_encoder(lzma_stream *strm, uint32_t preset, lzma_check check) lzma_nothrow lzma_attr_warn_unused_result { return _lzma_easy_encoder(strm, preset, check); }

extern LZMA_API(lzma_ret) _lzma_auto_decoder(lzma_stream *strm, uint64_t memlimit, uint32_t flags) lzma_nothrow lzma_attr_warn_unused_result;
extern lzma_ret lzma_auto_decoder(lzma_stream *strm, uint64_t memlimit, uint32_t flags) lzma_nothrow lzma_attr_warn_unused_result { return _lzma_auto_decoder(strm, memlimit, flags); }


void *_malloc(size_t size) { return malloc(size); }
void _free(void *p) { free(p); }
void *_memcpy(void *dst, const void *src, size_t size) { return memcpy(dst, src, size); }
void *_memset(void *s, int c, size_t n) { return memset(s, c, n); }
void *_memmove(void *dst, const void *src, size_t size) { return memmove(dst, src, size); }
int _memcmp(const void *dst, const void *src, size_t size) { return memcmp(dst, src, size); }

}